package com.easefun.polyvsdk.util;

import java.util.ArrayList;

import com.easefun.polyvsdk.PolyvSDKClient;
import com.easefun.polyvsdk.database.videoProgress.VideoProgressDatabaseService;
import com.easefun.polyvsdk.vo.PolyvVideoProgressVO;

import android.support.annotation.NonNull;

/**
 * 视频进度数据库工具类
 * @author TanQu 2017-3-30
 */
public class PolyvVideoProgressDatabaseUtil {
	
	/**
	 * 获取视频进度
	 * @param vid
	 * @return 毫秒
	 */
	public static int getVideoProgress(@NonNull String vid) {
		VideoProgressDatabaseService databaseService = PolyvSDKClient.getInstance().getVideoProgressService();
		if (databaseService == null) {
			return 0;
		}
		
		PolyvVideoProgressVO videoProgressVO = databaseService.getVideoProgress(vid);
		if (videoProgressVO == null) {
			return 0;
		}
		
		return videoProgressVO.getProgress();
	}
	
	/**
	 * 获取视频进度列表
	 * @return
	 */
	@NonNull
	public static ArrayList<PolyvVideoProgressVO> listVideoProgress() {
		VideoProgressDatabaseService databaseService = PolyvSDKClient.getInstance().getVideoProgressService();
		if (databaseService == null) {
			return new ArrayList<>(0);
		}
		
		return databaseService.listVideoProgress();
	}
}
