package com.easefun.polyvsdk.marquee;

import android.graphics.Color;
import android.view.animation.Animation;

/**
 * 跑马灯item
 */
public class PolyvMarqueeItem {
    public static final int STYLE_ROLL = 1;
    public static final int STYLE_FLICK = 2;
    public static final int STYLE_ROLL_FLICK = 3;
    public static final int STYLE_ROLL_15PERCENT = 4;
    public static final int STYLE_FLICK_15PERCENT = 5;
    // ms
    private int duration;
    private int color;
    private int size;
    private CharSequence text;
    private int repeatMode;
    private int repeatCount;
    private int textAlpha;
    private int style;
    // 隐藏间隔，ms
    private int interval;
    // 显示间隔，ms
    private int lifeTime;
    // 渐隐渐现间隔，ms
    private int tweenTime;
    private float textSpacing;

    // 描边
    private boolean hasStroke;
    private boolean blurStroke;
    private int strokeColor;
    private int strokeWidth;
    private int strokeAlpha;

    final boolean singleLine = true;
    boolean isAdd;
    PolyvMarqueeView marqueeView;

    public PolyvMarqueeItem() {
        duration = 5000;
        color = Color.GREEN;
        size = 16;
        text = "";
        repeatMode = Animation.RESTART;
        repeatCount = Animation.INFINITE;
        textAlpha = 255;
        style = STYLE_ROLL;
        interval = 1000;
        lifeTime = 1000;
        tweenTime = 1000;
        textSpacing = 0;

        hasStroke = false;
        blurStroke = false;
        strokeColor = Color.BLUE;
        strokeWidth = 5;
        strokeAlpha = 255;
    }

    private PolyvMarqueeItem update() {
        if (isAdd && marqueeView != null)
            marqueeView.removeItem(this).addItem(this);
        return this;
    }

    public int getStyle() {
        return style;
    }

    /**
     * 设置跑马灯的样式
     *
     * @param style 从右至左滚动：{@link PolyvMarqueeItem#STYLE_ROLL}，屏幕内随机位置闪烁：{@link PolyvMarqueeItem#STYLE_FLICK}，从右
     *              至左渐隐渐现的滚动：{@link PolyvMarqueeItem#STYLE_ROLL_FLICK}。默认为{@link #STYLE_ROLL}
     * @return
     */
    public PolyvMarqueeItem setStyle(int style) {
        this.style = style;
        return update();
    }

    public int getInterval() {
        return interval;
    }

    /**
     * 设置跑马灯文本隐藏间隔时间，单位为毫秒。与屏幕内随机位置闪烁的跑马灯样式相关。默认为1000。
     *
     * @param interval
     * @return
     */
    public PolyvMarqueeItem setInterval(int interval) {
        this.interval = interval;
        return update();
    }

    public int getLifeTime() {
        return lifeTime;
    }

    /**
     * 跑马灯文本显示时间，单位为毫秒。与屏幕内随机位置闪烁的跑马灯样式相关。默认为1000。
     *
     * @param lifeTime
     * @return
     */
    public PolyvMarqueeItem setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
        return update();
    }

    public int getTweenTime() {
        return tweenTime;
    }

    /**
     * 设置跑马灯文本渐隐渐现的间隔时间，单位为毫秒。与从右至左渐隐渐现滚动的跑马灯样式相关。默认为1000。
     *
     * @param tweenTime
     * @return
     */
    public PolyvMarqueeItem setTweenTime(int tweenTime) {
        this.tweenTime = tweenTime;
        return update();
    }

    public boolean isBlurStroke() {
        return blurStroke;
    }

    /**
     * 设置描边是否模糊。默认为false。
     *
     * @param blurStroke
     * @return
     */
    public PolyvMarqueeItem setBlurStroke(boolean blurStroke) {
        this.blurStroke = blurStroke;
        return update();
    }

    public int getTextAlpha() {
        return textAlpha;
    }

    /**
     * 设置跑马灯文本的透明度，范围[0,255]。默认为255。
     *
     * @param textAlpha
     * @return
     */
    public PolyvMarqueeItem setTextAlpha(int textAlpha) {
        this.textAlpha = textAlpha;
        return update();
    }

    public boolean isHasStroke() {
        return hasStroke;
    }

    /**
     * 设置跑马灯文本是否有描边。默认为false。
     *
     * @param hasStroke
     * @return
     */
    public PolyvMarqueeItem setHasStroke(boolean hasStroke) {
        this.hasStroke = hasStroke;
        return update();
    }

    public int getStrokeColor() {
        return strokeColor;
    }

    /**
     * 设置跑马灯文本的描边颜色。默认为蓝色。
     *
     * @param strokeColor
     * @return
     */
    public PolyvMarqueeItem setStrokeColor(int strokeColor) {
        this.strokeColor = strokeColor;
        return update();
    }

    public int getStrokeWidth() {
        return strokeWidth;
    }

    /**
     * 设置跑马灯文本的描边宽度。默认为5。
     *
     * @return
     */
    public PolyvMarqueeItem setStrokeWidth(int strokeWidth) {
        this.strokeWidth = strokeWidth;
        return update();
    }

    public int getStrokeAlpha() {
        return strokeAlpha;
    }

    /**
     * 设置跑马灯文本的描边的透明度，范围[0,255]。默认为255。
     *
     * @param strokeAlpha
     * @return
     */
    public PolyvMarqueeItem setStrokeAlpha(int strokeAlpha) {
        this.strokeAlpha = strokeAlpha;
        return update();
    }

    public int getDuration() {
        return duration;
    }

    /**
     * 设置跑马灯从右至左的滚动时长，单位为毫秒。与从右至左滚动及从左至右渐隐渐现滚动的跑马灯样式相关。默认为5000。
     *
     * @param duration
     * @return
     */
    public PolyvMarqueeItem setDuration(int duration) {
        this.duration = duration;
        return update();
    }

    public int getColor() {
        return color;
    }

    /**
     * 设置跑马灯文本的颜色。默认为绿色。
     *
     * @param color
     * @return
     */
    public PolyvMarqueeItem setColor(int color) {
        this.color = color;
        return update();
    }

    public int getSize() {
        return size;
    }

    /**
     * 设置跑马灯文本的字体大小。默认为16。
     *
     * @param size
     * @return
     */
    public PolyvMarqueeItem setSize(int size) {
        this.size = size;
        return update();
    }

    public CharSequence getText() {
        return text;
    }

    /**
     * 设置跑马灯显示的文本内容。默认为""。
     *
     * @param text
     * @return
     */
    public PolyvMarqueeItem setText(CharSequence text) {
        this.text = text;
        return update();
    }

    public boolean isSingleLine() {
        return singleLine;
    }

//    /**
//     * 设置跑马灯是否是单行显示。默认为true。
//     *
//     * @param singleLine
//     * @return
//     */
//    public PolyvMarqueeItem setSingleLine(boolean singleLine) {
//        this.singleLine = singleLine;
//        return update();
//    }

    public int getRepeatMode() {
        return repeatMode;
    }

    /**
     * 设置跑马灯重复的模式。默认为{@link Animation#RESTART}。
     *
     * @param repeatMode
     * @return
     */
    public PolyvMarqueeItem setRepeatMode(int repeatMode) {
        this.repeatMode = repeatMode;
        return update();
    }

    public int getRepeatCount() {
        return repeatCount;
    }

    /**
     * 设置跑马灯重复的次数。默认为{@link Animation#INFINITE}。
     *
     * @return
     */
    public PolyvMarqueeItem setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
        return update();
    }

    public float getTextSpacing() {
        return textSpacing;
    }

    /**
     * 设置跑马灯文本的间隔。默认为0。
     *
     * @param textSpacing
     * @return
     */
    public PolyvMarqueeItem setTextSpacing(float textSpacing) {
        this.textSpacing = textSpacing;
        return update();
    }
}
