package com.easefun.polyvsdk.ijk;

import com.easefun.polyvsdk.video.PolyvPlayErrorReason;
import com.easefun.polyvsdk.video.PolyvVideoView;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementCountDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementEventListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureClickListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureLeftDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureLeftUpListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureRightDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureRightUpListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureSwipeLeftListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnGestureSwipeRightListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnPlayPauseListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionAnswerTipsListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoPlayErrorLisener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoSRTListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoStatusListener;

import android.content.Context;
import android.util.AttributeSet;

/**
 * 视频主类<br/>
 * 改为 {@link com.easefun.polyvsdk.video.PolyvVideoView}
 * @version 1.0
 * @author TanQu 2016-9-14
 * @see com.easefun.polyvsdk.video.PolyvVideoView
 */
@Deprecated
public class IjkVideoView extends PolyvVideoView {

	public IjkVideoView(Context context) {
		super(context);
	}

	public IjkVideoView(Context context, AttributeSet attrs) {
		super(context, attrs, 0);
	}

	public IjkVideoView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}

	/**
	 * 等同于 {@code PolyvPlayerScreenRatio.VIDEO_LAYOUT_ORIGIN}}
	 * @see PolyvPlayerScreenRatio
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_ORIGIN = PolyvPlayerScreenRatio.VIDEO_LAYOUT_ORIGIN;
	/**
	 * 等同于 {@code PolyvPlayerScreenRatio.VIDEO_LAYOUT_SCALE}}
	 * @see PolyvPlayerScreenRatio
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_SCALE = PolyvPlayerScreenRatio.VIDEO_LAYOUT_SCALE;
	/**
	 * 等同于 {@code PolyvPlayerScreenRatio.VIDEO_LAYOUT_STRETCH}}
	 * @see PolyvPlayerScreenRatio
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_STRETCH = PolyvPlayerScreenRatio.VIDEO_LAYOUT_STRETCH;
	/**
	 * 等同于 {@code PolyvPlayerScreenRatio.VIDEO_LAYOUT_ZOOM}}
	 * @see PolyvPlayerScreenRatio
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_ZOOM = PolyvPlayerScreenRatio.VIDEO_LAYOUT_ZOOM;
	/**
	 * 等同于 {@code PolyvPlayerScreenRatio.VIDEO_LAYOUT_AUTO_FIT}}
	 * @see PolyvPlayerScreenRatio
	 */
	@Deprecated
	public static final int VIDEO_LAYOUT_AUTO_FIT = PolyvPlayerScreenRatio.VIDEO_LAYOUT_AUTO_FIT;

	/**
	 * 视频状态回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnVideoStatusListener
	 */
	@Deprecated
	public interface OnVideoStatusListener extends IPolyvOnVideoStatusListener {
		
	}

	/**
	 * 暂停，播放，播放完成监听回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnPlayPauseListener
	 */
	@Deprecated
	public interface OnPlayPauseListener extends IPolyvOnPlayPauseListener {
		
	}

	/**
	 * 设置视频播放/暂停/播放完成回调
	 * @see #setOnPlayPauseListener(IPolyvOnPlayPauseListener)
	 * @param l
	 */
	@Deprecated
	public void setOnPlayPauseListener(OnPlayPauseListener l) {
		super.setOnPlayPauseListener(l);
	}

	/**
	 * 问答弹出回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnQuestionOutListener
	 */
	@Deprecated
	public interface OnQuestionOutListener extends IPolyvOnQuestionOutListener {
		
	}

	/**
	 * 问答答案提示回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnQuestionAnswerTipsListener
	 */
	@Deprecated
	public interface OnQuestionAnswerTipsListener extends IPolyvOnQuestionAnswerTipsListener {
		
	}

	/**
	 * 视频播放出错回调接口
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnVideoPlayErrorLisener
	 */
	@Deprecated
	public interface OnVideoPlayErrorLisener extends IPolyvOnVideoPlayErrorLisener {
		
	}

	/**
	 * 失败原因
	 * @version 1.0
	 * @author TanQu
	 */
	public static class ErrorReason {
		/** 失败类型 */
		private final ErrorType type;

		public ErrorReason(ErrorType type) {
			this.type = type;
		}

		public ErrorType getType() {
			return type;
		}

		/**
		 * 错误类型
		 * @author TanQu
		 */
		public enum ErrorType {
			/**未定义*/
			UNDEFINED(0),
			/** 无法连接网络 */
			NETWORK_DENIED(PolyvPlayErrorReason.NETWORK_DENIED),
			/** 流量超标 */
			OUT_FLOW(PolyvPlayErrorReason.OUT_FLOW),
			/** 账号过期 */
			TIMEOUT_FLOW(PolyvPlayErrorReason.TIMEOUT_FLOW),
			/** 本地视频文件错误 */
			LOCAL_VIEWO_ERROR(PolyvPlayErrorReason.LOCAL_VIEWO_ERROR),
			/** 视频开始播放错误 */
			START_ERROR(PolyvPlayErrorReason.START_ERROR),
			/** 没有权限访问视频 */
			NOT_PERMISSION(PolyvPlayErrorReason.NOT_PERMISSION),
			/** 没有设置用户token */
			USER_TOKEN_ERROR(PolyvPlayErrorReason.USER_TOKEN_ERROR),
			/** 视频状态错误 */
			VIDEO_STATUS_ERROR(PolyvPlayErrorReason.VIDEO_STATUS_ERROR),
			/** 问答json加载错误 see {@code QUESTION_ERROR}*/
			@Deprecated
			QUESTION_JSON_ERROR(PolyvPlayErrorReason.QUESTION_JSON_ERROR),
			/** 问答json解析错误 see {@code QUESTION_ERROR}*/
			@Deprecated
			QUESTION_JSON_PARSE_ERROR(PolyvPlayErrorReason.QUESTION_JSON_PARSE_ERROR),
			/** vid错误 */
			VID_ERROR(PolyvPlayErrorReason.VID_ERROR),
			/** 码率错误 */
			BITRATE_ERROR(PolyvPlayErrorReason.BITRATE_ERROR),
			/** video取得为null */
			VIDEO_NULL(PolyvPlayErrorReason.VIDEO_NULL),
			/** mp4链接数量错误 */
			MP4_LINK_NUM_ERROR(PolyvPlayErrorReason.MP4_LINK_NUM_ERROR),
			/** m3u8链接数量错误 */
			M3U8_LINK_NUM_ERROR(PolyvPlayErrorReason.M3U8_LINK_NUM_ERROR),
			/** 播放视频速度为null */
			HLS_SPEED_TYPE_NULL(PolyvPlayErrorReason.HLS_SPEED_TYPE_NULL),
			/** 没有缓存视频 */
			NOT_LOCAL_VIDEO(PolyvPlayErrorReason.NOT_LOCAL_VIDEO),
			/** 1.5倍播放地址为空 */
			HLS_15X_INDEX_EMPTY(PolyvPlayErrorReason.HLS_15X_INDEX_EMPTY),
			/** 1.5倍播放地址错误 */
			HLS_15X_ERROR(PolyvPlayErrorReason.HLS_15X_ERROR),
			/** 1.5倍播放地址错误 */
			HLS_15X_URL_ERROR(PolyvPlayErrorReason.HLS_15X_URL_ERROR),
			/** m3u8 15x链接数量错误 */
			M3U8_15X_LINK_NUM_ERROR(PolyvPlayErrorReason.M3U8_15X_LINK_NUM_ERROR),
			/** 切换码率相同 */
			CHANGE_EQUAL_BITRATE(PolyvPlayErrorReason.CHANGE_EQUAL_BITRATE),
			/** 切换播放速度相同 */
			CHANGE_EQUAL_HLS_SPEED(PolyvPlayErrorReason.CHANGE_EQUAL_HLS_SPEED),
			/** 不能切换码率 */
			CAN_NOT_CHANGE_BITRATE(PolyvPlayErrorReason.CAN_NOT_CHANGE_BITRATE),
			/** 不能切换速度 */
			CAN_NOT_CHANGE_HLS_SPEED(PolyvPlayErrorReason.CAN_NOT_CHANGE_HLS_SPEED),
			/** 视频信息加载过程中出错，播放器不会再返回该错误类型 */
			@Deprecated
			LOADING_VIDEO_ERROR(PolyvPlayErrorReason.LOADING_VIDEO_ERROR),
			/** 问答错误 */
			QUESTION_ERROR(PolyvPlayErrorReason.QUESTION_ERROR);

			private final int code;

			ErrorType(int code) {
				this.code = code;
			}

			/**
			 * 取得错误类型对应的code
			 * @return
			 */
			public int getCode() {
				return code;
			}

			public static ErrorType getErrorType(@PolyvPlayErrorReason.PlayErrorReason int playErrorReason) {
				switch (playErrorReason) {
					case PolyvPlayErrorReason.BITRATE_ERROR:
						return ErrorType.BITRATE_ERROR;
					case PolyvPlayErrorReason.CAN_NOT_CHANGE_BITRATE:
						return ErrorType.CAN_NOT_CHANGE_BITRATE;
					case PolyvPlayErrorReason.CAN_NOT_CHANGE_HLS_SPEED:
						return ErrorType.CAN_NOT_CHANGE_HLS_SPEED;
					case PolyvPlayErrorReason.CHANGE_EQUAL_BITRATE:
						return ErrorType.CHANGE_EQUAL_BITRATE;
					case PolyvPlayErrorReason.CHANGE_EQUAL_HLS_SPEED:
						return ErrorType.CHANGE_EQUAL_HLS_SPEED;
					case PolyvPlayErrorReason.HLS_15X_ERROR:
						return ErrorType.HLS_15X_ERROR;
					case PolyvPlayErrorReason.HLS_15X_INDEX_EMPTY:
						return ErrorType.HLS_15X_INDEX_EMPTY;
					case PolyvPlayErrorReason.HLS_15X_URL_ERROR:
						return ErrorType.HLS_15X_URL_ERROR;
					case PolyvPlayErrorReason.HLS_SPEED_TYPE_NULL:
						return ErrorType.HLS_SPEED_TYPE_NULL;
					case PolyvPlayErrorReason.LOADING_VIDEO_ERROR:
						return ErrorType.LOADING_VIDEO_ERROR;
					case PolyvPlayErrorReason.LOCAL_VIEWO_ERROR:
						return ErrorType.LOCAL_VIEWO_ERROR;
					case PolyvPlayErrorReason.M3U8_15X_LINK_NUM_ERROR:
						return ErrorType.M3U8_15X_LINK_NUM_ERROR;
					case PolyvPlayErrorReason.M3U8_LINK_NUM_ERROR:
						return ErrorType.M3U8_LINK_NUM_ERROR;
					case PolyvPlayErrorReason.MP4_LINK_NUM_ERROR:
						return ErrorType.MP4_LINK_NUM_ERROR;
					case PolyvPlayErrorReason.NETWORK_DENIED:
						return ErrorType.NETWORK_DENIED;
					case PolyvPlayErrorReason.NOT_LOCAL_VIDEO:
						return ErrorType.NOT_LOCAL_VIDEO;
					case PolyvPlayErrorReason.NOT_PERMISSION:
						return ErrorType.NOT_PERMISSION;
					case PolyvPlayErrorReason.OUT_FLOW:
						return ErrorType.OUT_FLOW;
					case PolyvPlayErrorReason.QUESTION_ERROR:
						return ErrorType.QUESTION_ERROR;
					case PolyvPlayErrorReason.QUESTION_JSON_ERROR:
						return ErrorType.QUESTION_JSON_ERROR;
					case PolyvPlayErrorReason.QUESTION_JSON_PARSE_ERROR:
						return ErrorType.QUESTION_JSON_PARSE_ERROR;
					case PolyvPlayErrorReason.START_ERROR:
						return ErrorType.START_ERROR;
					case PolyvPlayErrorReason.TIMEOUT_FLOW:
						return ErrorType.TIMEOUT_FLOW;
					case PolyvPlayErrorReason.USER_TOKEN_ERROR:
						return ErrorType.USER_TOKEN_ERROR;
					case PolyvPlayErrorReason.VIDEO_NULL:
						return ErrorType.VIDEO_NULL;
					case PolyvPlayErrorReason.VIDEO_STATUS_ERROR:
						return ErrorType.VIDEO_STATUS_ERROR;
					case PolyvPlayErrorReason.VID_ERROR:
						return ErrorType.VID_ERROR;
				}

				return UNDEFINED;
			}
		}
	}

	/**
	 * 图片广告弹出回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnAdvertisementOutListener
	 */
	@Deprecated
	public interface OnAdvertisementOutListener extends IPolyvOnAdvertisementOutListener {
		
	}

	/**
	 * 视频广告倒计时回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnAdvertisementCountDownListener
	 */
	@Deprecated
	public interface OnAdvertisementCountDownListener extends IPolyvOnAdvertisementCountDownListener {
		
	}

	/**
	 * 视频广告显示/点击回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnAdvertisementEventListener
	 */
	@Deprecated
	public interface OnAdvertisementEventListener extends IPolyvOnAdvertisementEventListener {

	}

	/**
	 * 视频字幕监听回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnVideoSRTListener
	 */
	@Deprecated
	public interface OnVideoSRTListener extends IPolyvOnVideoSRTListener {
		
	}

	/**
	 * 设置手势左向上回调
	 * @see #setOnGestureLeftUpListener(IPolyvOnGestureLeftUpListener)
	 * @param mLeftUp
	 */
	@Deprecated
	public void setLeftUp(LeftUp mLeftUp) {
		setOnGestureLeftUpListener(mLeftUp);
	}

	/**
	 * 设置手势左向下回调
	 * @see #setOnGestureLeftDownListener(IPolyvOnGestureLeftDownListener)
	 * @param mLeftDown
	 */
	@Deprecated
	public void setLeftDown(LeftDown mLeftDown) {
		setOnGestureLeftDownListener(mLeftDown);
	}

	/**
	 * 设置手势右向上回调
	 * @see #setOnGestureRightUpListener(IPolyvOnGestureRightUpListener)
	 * @param mRightUp
	 */
	@Deprecated
	public void setRightUp(RightUp mRightUp) {
		setOnGestureRightUpListener(mRightUp);
	}

	/**
	 * 设置手势右向下回调
	 * @see #setOnGestureRightDownListener(IPolyvOnGestureRightDownListener)
	 * @param mRightDown
	 */
	@Deprecated
	public void setRightDown(RightDown mRightDown) {
		setOnGestureRightDownListener(mRightDown);
	}

	/**
	 * 设置手势左滑回调
	 * @see #setOnGestureSwipeLeftListener(IPolyvOnGestureSwipeLeftListener)
	 * @param mSwipeLeft
	 */
	@Deprecated
	public void setSwipeLeft(SwipeLeft mSwipeLeft) {
		setOnGestureSwipeLeftListener(mSwipeLeft);
	}

	/**
	 * 设置手势右滑回调
	 * @see #setOnGestureSwipeRightListener(IPolyvOnGestureSwipeRightListener)
	 * @param mSwipeRight
	 */
	@Deprecated
	public void setSwipeRight(SwipeRight mSwipeRight) {
		setOnGestureSwipeRightListener(mSwipeRight);
	}

	/**
	 * 设置手势单击回调
	 * @see #setOnGestureClickListener(IPolyvOnGestureClickListener)
	 * @param mClick
	 */
	@Deprecated
	public void setClick(Click mClick) {
		setOnGestureClickListener(mClick);
	}

	/**
	 * 手势左向上回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnGestureLeftUpListener
	 */
	@Deprecated
	public interface LeftUp extends IPolyvOnGestureLeftUpListener {
		
	}

	/**
	 * 手势左向下回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnGestureLeftDownListener
	 */
	@Deprecated
	public interface LeftDown extends IPolyvOnGestureLeftDownListener {
		
	}

	/**
	 * 手势右向上回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnGestureRightUpListener
	 */
	@Deprecated
	public interface RightUp extends IPolyvOnGestureRightUpListener {
		
	}

	/**
	 * 手势右向下回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnGestureRightDownListener
	 */
	@Deprecated
	public interface RightDown extends IPolyvOnGestureRightDownListener {
		
	}

	/**
	 * 手势左滑回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnGestureSwipeLeftListener
	 */
	@Deprecated
	public interface SwipeLeft extends IPolyvOnGestureSwipeLeftListener {
		
	}

	/**
	 * 手势右滑回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnGestureSwipeRightListener
	 */
	@Deprecated
	public interface SwipeRight extends IPolyvOnGestureSwipeRightListener {
		
	}

	/**
	 * 手势单击回调
	 * @version 1.0
	 * @author TanQu
	 * @see IPolyvOnGestureClickListener
	 */
	@Deprecated
	public interface Click extends IPolyvOnGestureClickListener {
		
	}
}
