package com.easefun.polyvsdk;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.easefun.polyvsdk.vo.PolyvQAFormatVO;

import android.text.TextUtils;

import org.json.JSONException;

/**
 * 问答工具类
 * @author TanQu 2016-1-27
 */
public class PolyvQuestionUtil {
	
	/**
	 * 格式化问题or问答答案，建议使用新方法{@link #parseQA2(String)}
	 * @param str
	 * @return 格式化后的VO列表
	 * @see #parseQA2(String)
	 * @see QAFormatVO
	 * @throws JSONException 不再抛出该异常
	 */
	@Deprecated
	public static List<QAFormatVO> parseQA(String str) throws JSONException {
    	Pattern imageUrlPattern = Pattern.compile("\\[\\[[^\\[\\]]*\\]\\]");
    	Matcher imageUrlMatcher = imageUrlPattern.matcher(str);
    	
    	Pattern urlPattern = Pattern.compile("^[hH][tT][tT][pP].+$");
		Matcher urlMatcher = null;
		
		class SubIndex {
	    	private int startIndex = 0;
	    	private int endIndex = 0;
	    }
		
		List<SubIndex> subIndexList = new ArrayList<>();
		List<String> urlList = new ArrayList<>();
		int length = str.length();
		String url = "";
		SubIndex subIndex = null;
    	while(imageUrlMatcher.find()) {
    		subIndex = new SubIndex();
    		subIndex.startIndex = imageUrlMatcher.start();
    		subIndex.endIndex = imageUrlMatcher.end();
    		subIndexList.add(subIndex);
    		
    		url = imageUrlMatcher.group();
    		// 去掉两边中括号
    		url = url.substring(2, url.length() - 2);
    		urlMatcher = urlPattern.matcher(url);
			if (!urlMatcher.find()) {
				url = "http://go.polyv.net/gs.php?" + url;
			}
    		
    		urlList.add(url);
    	}
    	
    	List<QAFormatVO> qaFormatList = new ArrayList<>();
    	int nextIndex = 0, index = 0;
    	for (SubIndex subIndexTmp : subIndexList) {
    		String content = str.substring(nextIndex, subIndexTmp.startIndex);
    		if (!TextUtils.isEmpty(content)) {
    			qaFormatList.add(new QAFormatVO(PolyvQAFormatVO.StringType.STRING, content));
    		}
    		
    		qaFormatList.add(new QAFormatVO(PolyvQAFormatVO.StringType.URL, urlList.get(index)));
    		nextIndex = subIndexTmp.endIndex;
    		index++;
    	}
    	
    	if (nextIndex < length) {
    		qaFormatList.add(new QAFormatVO(PolyvQAFormatVO.StringType.STRING, str.substring(nextIndex, length)));
    	}
    	
    	return qaFormatList;
    }

	/**
	 * 格式化问题or问答答案
	 * @param str
	 * @return 格式化后的VO列表
	 * @see PolyvQAFormatVO
	 */
	public static List<PolyvQAFormatVO> parseQA2(String str) {
		//同parseQA一样的代码，只是返回值不同
		Pattern imageUrlPattern = Pattern.compile("\\[\\[[^\\[\\]]*\\]\\]");
		Matcher imageUrlMatcher = imageUrlPattern.matcher(str);

		Pattern urlPattern = Pattern.compile("^[hH][tT][tT][pP].+$");
		Matcher urlMatcher = null;

		class SubIndex {
			private int startIndex = 0;
			private int endIndex = 0;
		}

		List<SubIndex> subIndexList = new ArrayList<>();
		List<String> urlList = new ArrayList<>();
		int length = str.length();
		String url = "";
		SubIndex subIndex = null;
		while(imageUrlMatcher.find()) {
			subIndex = new SubIndex();
			subIndex.startIndex = imageUrlMatcher.start();
			subIndex.endIndex = imageUrlMatcher.end();
			subIndexList.add(subIndex);

			url = imageUrlMatcher.group();
			// 去掉两边中括号
			url = url.substring(2, url.length() - 2);
			urlMatcher = urlPattern.matcher(url);
			if (!urlMatcher.find()) {
				url = "http://go.polyv.net/gs.php?" + url;
			}

			urlList.add(url);
		}

		List<PolyvQAFormatVO> qaFormatList = new ArrayList<>();
		int nextIndex = 0, index = 0;
		for (SubIndex subIndexTmp : subIndexList) {
			String content = str.substring(nextIndex, subIndexTmp.startIndex);
			if (!TextUtils.isEmpty(content)) {
				qaFormatList.add(new PolyvQAFormatVO(PolyvQAFormatVO.StringType.STRING, content));
			}

			qaFormatList.add(new PolyvQAFormatVO(PolyvQAFormatVO.StringType.URL, urlList.get(index)));
			nextIndex = subIndexTmp.endIndex;
			index++;
		}

		if (nextIndex < length) {
			qaFormatList.add(new PolyvQAFormatVO(PolyvQAFormatVO.StringType.STRING, str.substring(nextIndex, length)));
		}

		return qaFormatList;
	}
}
