/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;

public class RelativeImageSpan
extends ImageSpan {
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_TEXTBOTTOM = 2;
    public static final int ALIGN_CENTER = 3;
    private int status = 0;
    private float scale = 1.0f;

    public RelativeImageSpan(Drawable d) {
        super(d);
    }

    public RelativeImageSpan(Drawable d, int verticalAlignment) {
        super(d, verticalAlignment);
        this.status = verticalAlignment;
    }

    public RelativeImageSpan(Drawable d, int verticalAlignment, float spacingScale) {
        super(d, verticalAlignment);
        this.status = verticalAlignment;
        this.scale = spacingScale;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        Drawable b = this.getDrawable();
        canvas.save();
        int transY = 0;
        switch (this.status) {
            case 3: {
                transY = (bottom - top - b.getBounds().bottom) / 2 + top;
                break;
            }
            case 0: {
                transY = bottom - b.getBounds().bottom;
                break;
            }
            case 1: {
                transY = bottom - b.getBounds().bottom;
                transY -= paint.getFontMetricsInt().descent;
                break;
            }
            case 2: {
                transY = bottom - b.getBounds().bottom;
                transY -= paint.getFontMetricsInt().descent - bottom / 4;
            }
        }
        canvas.translate(x + 3.0f * this.scale, (float)transY);
        b.draw(canvas);
        canvas.restore();
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        Drawable d = this.getDrawable();
        Rect rect = d.getBounds();
        switch (this.status) {
            case 3: {
                if (fm == null) break;
                Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
                int fontHeight = fmPaint.bottom - fmPaint.top;
                int drHeight = rect.bottom - rect.top;
                int top = drHeight / 2 - fontHeight / 4;
                int bottom = drHeight / 2 + fontHeight / 4;
                fm.ascent = -bottom;
                fm.top = -bottom;
                fm.bottom = top;
                fm.descent = top;
                break;
            }
            default: {
                if (fm == null) break;
                fm.ascent = -rect.bottom;
                fm.descent = 0;
                fm.top = fm.ascent;
                fm.bottom = 0;
            }
        }
        return rect.right + (int)(3.0f * this.scale * 2.0f);
    }
}

