/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.tool;

import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.exception.ExHttpException;
import com.eaglexad.lib.http.ible.IExHttpStack;
import com.eaglexad.lib.http.ible.IExNetwork;

import java.net.HttpURLConnection;
import java.util.Collections;
import java.util.Map;

/**
 * @author Aloneter
 * @ClassName: ExNetwork
 * @Description:
 */
public class ExNetwork implements IExNetwork {

    public final IExHttpStack mHttpStack;

    public ExNetwork(IExHttpStack httpStack) {
        mHttpStack = httpStack;
    }

    @Override
    public ExResponse performRequest(ExRequest request) throws ExHttpException {

        while (true) {
            Map<String, String> responseHeaders = Collections.emptyMap();

            try {

                return mHttpStack.performRequest(request, responseHeaders);
            } catch (ExHttpException e) {
                throw e;
            }
        }
    }

}
