/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.tool;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;

import com.eaglexad.lib.http.ext.ByteArrayPool;
import com.eaglexad.lib.http.ext.PoolingByteArrayOutputStream;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.security.MessageDigest;
import java.util.List;
import java.util.Map;

/**
 * @author Aloneter
 * @ClassName: ExHttpUtils
 * @Description:
 */
public class ExHttpUtils {

    public static boolean isEmpty(Object obj) {

        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return ((String) obj).length() == 0;
        }
        if (obj instanceof List<?>) {
            List<?> list = (List<?>) obj;
            return list.size() == 0;
        }
        if (obj instanceof Map<?, ?>) {
            Map<?, ?> map = (Map<?, ?>) obj;
            return map.size() == 0;
        }
        if (obj instanceof int[]) {
            int[] array = (int[]) obj;
            return array.length == 0;
        }
        if (obj instanceof float[]) {
            float[] array = (float[]) obj;
            return array.length == 0;
        }
        if (obj instanceof long[]) {
            long[] array = (long[]) obj;
            return array.length == 0;
        }
        if (obj instanceof double[]) {
            double[] array = (double[]) obj;
            return array.length == 0;
        }
        if (obj instanceof Object[]) {
            Object[] array = (Object[]) obj;
            return array.length == 0;
        }

        return false;
    }

    public static boolean isConnected(Context context) {

        if (context == null) {
            return false;
        }
        ConnectivityManager connectivity = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);

        if (connectivity == null) {

            return false;
        } else {
            NetworkInfo networkInfo = connectivity.getActiveNetworkInfo();

            if (networkInfo != null && networkInfo.isConnected()) {

                return true;
            }
        }

        return false;
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            } catch (Throwable ignored) {
            }
        }
    }

    public static long getInputStreamLength(InputStream inputStream) {

        try {
            if (inputStream instanceof FileInputStream || inputStream instanceof ByteArrayInputStream) {
                return inputStream.available();
            }
        } catch (Throwable ignored) {
        }

        return -1L;
    }

    public static String getFileContentType(File file) {

        String filename = file.getName();
        String contentType = HttpURLConnection.guessContentTypeFromName(filename);

        if (TextUtils.isEmpty(contentType)) {
            contentType = "application/octet-stream";
        } else {
            contentType = contentType.replaceFirst("\\/jpg$", "/jpeg");
        }
        return contentType;
    }

    public static byte[] inputStreamToBytes(InputStream inputStream, long contentLength) throws IOException {

        ByteArrayPool pool = new ByteArrayPool(4096);
        PoolingByteArrayOutputStream bytes = new PoolingByteArrayOutputStream(pool, (int) contentLength);
        byte[] buffer = null;

        try {
            buffer = pool.getBuf(1024);
            int count;

            while ((count = inputStream.read(buffer)) != -1) {
                bytes.write(buffer, 0, count);
            }

            return bytes.toByteArray();
        } finally {
            pool.returnBuf(buffer);
            bytes.close();
        }
    }

    public static String byteToString(byte[] data, String charset) {

        if (isEmpty(data)) {
            return null;
        }

        try {
            if (isEmpty(charset)) {
                return new String(data);
            }

            return new String(data, charset);
        } catch (UnsupportedEncodingException e) {
            return new String(data);
        }
    }

    public static String getMD5(String val) {

        byte[] hash = null;

        try {
            hash = MessageDigest.getInstance("MD5").digest(val.getBytes("UTF-8"));
        } catch (Exception e) {
            e.printStackTrace();
        }

        if (hash == null) {

            return "";
        }

        StringBuilder hex = new StringBuilder(hash.length * 2);

        for (byte b : hash) {
            if ((b & 0xFF) < 0x10) {
                hex.append("0");
            }

            hex.append(Integer.toHexString(b & 0xFF));
        }

        return hex.toString();
    }

}
