/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.tool;

import android.os.Process;

import com.eaglexad.lib.http.ExHttp;
import com.eaglexad.lib.http.entry.ExError;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.exception.ErrorNetwork;
import com.eaglexad.lib.http.exception.ExHttpException;
import com.eaglexad.lib.http.ible.IExCache;
import com.eaglexad.lib.http.ible.IExConvert;
import com.eaglexad.lib.http.ible.IExNetwork;
import com.eaglexad.lib.http.ible.IExResponseDelivery;

import java.util.concurrent.BlockingQueue;

/**
 * @author Aloneter
 * @ClassName: ExDispatcherNetwork
 * @Description:
 */
public class ExDispatcherNetwork extends Thread {

    private boolean mQuit;
    private final IExNetwork mNetWork;
    private final BlockingQueue<ExRequest> mNetworkQueue;
    private final IExResponseDelivery mResponseDelivery;

    public ExDispatcherNetwork(BlockingQueue<ExRequest> networkQueue, IExNetwork netWork, IExResponseDelivery delivery) {

        mNetWork = netWork;
        mNetworkQueue = networkQueue;
        mResponseDelivery = delivery;
    }

    @Override
    public void run() {

        android.os.Process.setThreadPriority(Process.THREAD_PRIORITY_BACKGROUND);

        while (true) {
            try {
                final ExRequest request = mNetworkQueue.take();

                if (request.isCancel) {
                    continue;
                }

                execute(request, false);

            } catch (InterruptedException e) {
                if (mQuit) {
                    return;
                }
            }
        }
    }

    public void execute(final ExRequest request, boolean isSync) {

        try {
            if (!ExHttpUtils.isConnected(ExHttp.getContext())) {
                useCacheToResponse(request, isSync);

                throw new ErrorNetwork("no network");
            }

            final ExResponse response = mNetWork.performRequest(request);

            final IExCache iExCache = request.getCacheIEx();
            final IExConvert iExConvert = request.getConvertIEx();

            if (!ExHttpUtils.isEmpty(iExConvert) && !ExHttpUtils.isEmpty(request.responseClazz)) {
                response.response = iExConvert.getByte2Cls(response.data, request.responseClazz);
            } else {
                response.response = ExHttpUtils.byteToString(response.data, request.charset);
            }
            if (response.isSuccess) {
                if (request.shouldCache && !ExHttpUtils.isEmpty(iExCache)) {
                    mResponseDelivery.postResponse(request, response, isSync, new Runnable() {

                        @Override
                        public void run() {

                            if (!ExHttpUtils.isEmpty(iExCache)) {
                                iExCache.put(request.getCacheGroupKey(), request.getCacheKey(), ExHttpUtils.byteToString(response.data, request.charset));
                            }
                        }
                    });

                    return;
                }

                mResponseDelivery.postResponse(request, response, isSync);
            } else {
                useCacheToResponse(request, isSync);

                mResponseDelivery.postError(request, ExError.newInstance(response), isSync);
            }
        } catch (ExHttpException http) {
            mResponseDelivery.postError(request, ExError.newInstance(http), isSync);
        }
    }

    private void useCacheToResponse(ExRequest request, boolean isSync) {

        final IExCache iExCache = request.getCacheIEx();
        final IExConvert iExConvert = request.getConvertIEx();

        if (request.shouldCache && !ExHttpUtils.isEmpty(iExCache) && iExCache.contains(request.getCacheKey())) {
            IExCache.Entry entry = iExCache.get(request.getCacheKey());

            if (request.cacheType == ExHttp.CacheType.REQUEST_AFTER && !ExHttpUtils.isEmpty(entry.value)) {
                ExResponse.Builder builder = new ExResponse.Builder(request.what);

                builder.setIsCache();
                builder.setIsSuccess();
                builder.setReuest(request);

                ExResponse responseCache = builder.builder();

                if (!ExHttpUtils.isEmpty(iExConvert) && !ExHttpUtils.isEmpty(request.responseClazz)) {
                    responseCache.response = iExConvert.getString2Cls(entry.value, request.responseClazz);
                }
                if (!ExHttpUtils.isEmpty(responseCache.response)) {
                    mResponseDelivery.postResponse(request, responseCache, isSync);
                }
            }
        }
    }

    public void quit() {
        mQuit = true;
        interrupt();
    }

}
