/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.tool;

import android.os.Process;

import com.eaglexad.lib.http.ExHttp;
import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.entry.ExResponse;
import com.eaglexad.lib.http.ible.IExCache;
import com.eaglexad.lib.http.ible.IExConvert;
import com.eaglexad.lib.http.ible.IExResponseDelivery;

import java.util.concurrent.BlockingQueue;

/**
 * @author Aloneter
 * @ClassName: ExDispatcherCache
 * @Description:
 */
public class ExDispatcherCache extends Thread {

    private boolean mQuit;
    private final BlockingQueue<ExRequest> mCacheQueue;
    private final BlockingQueue<ExRequest> mNetworkQueue;
    private final IExResponseDelivery mResponseDelivery;

    public ExDispatcherCache(BlockingQueue<ExRequest> cacheQueue, BlockingQueue<ExRequest> networkQueue, IExResponseDelivery delivery) {

        mCacheQueue = cacheQueue;
        mNetworkQueue = networkQueue;
        mResponseDelivery = delivery;
    }

    @Override
    public void run() {

        android.os.Process.setThreadPriority(Process.THREAD_PRIORITY_BACKGROUND);

        while (true) {
            try {
                final ExRequest request = mCacheQueue.take();

                if (request.isCancel) {
                    continue;
                }

                execute(request, false);

                mNetworkQueue.put(request);

            } catch (InterruptedException e) {
                if (mQuit) {
                    return;
                }
            }
        }
    }

    public void execute(final ExRequest request, boolean isSync) {

        final IExCache iExCache = request.getCacheIEx();
        final IExConvert iExConvert = request.getConvertIEx();

        if (request.shouldCache && !ExHttpUtils.isEmpty(iExCache) && iExCache.contains(request.getCacheKey())) {
            IExCache.Entry entry = iExCache.get(request.getCacheKey());

            if (System.currentTimeMillis() - entry.lastModifiedTime > request.cacheTimeout) {
                iExCache.remove(request.getCacheKey());
            } else {
                if (request.cacheType == ExHttp.CacheType.REQUEST_BEFORE && !ExHttpUtils.isEmpty(entry.value)) {
                    ExResponse.Builder builder = new ExResponse.Builder(request.what);

                    builder.setIsCache();
                    builder.setIsSuccess();
                    builder.setReuest(request);

                    ExResponse responseCache = builder.builder();

                    if (!ExHttpUtils.isEmpty(iExConvert) && !ExHttpUtils.isEmpty(request.responseClazz)) {
                        responseCache.response = iExConvert.getString2Cls(entry.value, request.responseClazz);
                    }
                    if (!ExHttpUtils.isEmpty(responseCache.response)) {
                        mResponseDelivery.postResponse(request, responseCache, isSync);
                    }
                }
            }
        }
    }

    public void quit() {
        mQuit = true;
        interrupt();
    }

}
