package com.eaglexad.lib.http.ible;

import com.eaglexad.lib.http.tool.ExHttpUtils;

/**
 * @author Aloneter
 * @ClassName: IExCache
 * @Description:
 */
public interface IExCache {

    void initialize();

    Entry get(String key);

    boolean contains(String key);

    void put(String groupKey, String key, String value);

    void remove(String key);

    void clear();

    void clear(String groupKey);

    class Entry {

        public String key;
        public String value;
        public String md5;
        public long lastModifiedTime;

        private Entry(String key, String value) {

            this.key = key;
            this.value = value;
            this.lastModifiedTime = System.currentTimeMillis();
            this.md5 = ExHttpUtils.getMD5(value);
        }

        public static Entry newInstance(String key, String value) {

            return new Entry(key, value);
        }

    }

}
