/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.entry;

import java.io.File;

/**
 * @author Aloneter
 * @ClassName: ExDownload
 * @Description:
 */
public class ExDownload {

    public static final String CONSTANT_DEFAULT_EXT = ".dl0";
    public static final String CONSTANT_DEFAULT_PATH = "";
    public static final String CONSTANT_DEFAULT_NAME = "EX_" + System.currentTimeMillis();

    public String name;
    public String saveName;
    public String saveFilePath;
    public String ext;

    public boolean isOverride;

    public long currSize; // 当前大小
    public long totalSize; // 总大小

    public int currProgress; // 当前进度

    private ExDownload(Builder builder) {

        this.name = builder.name;
        this.saveName = builder.saveName;
        this.saveFilePath = builder.saveFilePath;
        this.ext = builder.ext;
    }

    public static String getName(File file) {

        return CONSTANT_DEFAULT_NAME;
    }

    public static String getSaveFilePath(File file) {

        return CONSTANT_DEFAULT_PATH;
    }

    public static String getExt(File file) {

        return CONSTANT_DEFAULT_EXT;
    }

    public static class Builder {

        public String name = "";
        public String saveName = "";
        public String saveFilePath = "";
        public String ext = "";

        public Builder(String name, String saveName, String saveFilePath, String ext) {

            this.name = name;
            this.saveName = saveName;
            this.saveFilePath = saveFilePath;
            this.ext = ext;
        }

        public ExDownload builder() {

            return new ExDownload(this);
        }

    }

}
