/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.body;

import android.net.Uri;

import com.eaglexad.lib.http.entry.ExRequest;
import com.eaglexad.lib.http.ible.IExRequestBody;
import com.eaglexad.lib.http.tool.ExHttpUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

/**
 * @author Aloneter
 * @ClassName: ExUrlEncodedParamsBody
 * @Description:
 */
public class ExUrlEncodedParamsBody implements IExRequestBody {

    private byte[] mContent;
    private String mCharset = "UTF-8";

    public ExUrlEncodedParamsBody(List<ExRequest.KeyValue> bodyParams, String charset) throws IOException {

        if (!ExHttpUtils.isEmpty(charset)) {
            mCharset = charset;
        }

        StringBuilder stringBuilder = new StringBuilder();

        if (!ExHttpUtils.isEmpty(bodyParams)) {
            for (ExRequest.KeyValue param : bodyParams) {
                String key = param.key;
                String value = param.getValueStr();

                if (!ExHttpUtils.isEmpty(key) && !ExHttpUtils.isEmpty(value)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("&");
                    }
                    stringBuilder.append(Uri.encode(key, mCharset));
                    stringBuilder.append("=");
                    stringBuilder.append(Uri.encode(value, mCharset));
                }
            }
        }

        mContent = stringBuilder.toString().getBytes(mCharset);
    }

    @Override
    public long getContentLength() {

        return mContent.length;
    }

    @Override
    public void setContentType(String contentType) {

    }

    @Override
    public String getContentType() {

        return "application/x-www-form-urlencoded;charset=" + mCharset;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {

        out.write(mContent);
        out.flush();
    }

}
