/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.body;

import com.eaglexad.lib.http.ible.IExRequestBody;
import com.eaglexad.lib.http.tool.ExHttpUtils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

/**
 * @author Aloneter
 * @ClassName: ExStringBody
 * @Description:
 */
public class ExStringBody implements IExRequestBody {

    private byte[] mContent;
    private String mContentType;
    private String mCharset = "UTF-8";

    public ExStringBody(String content, String charset) throws UnsupportedEncodingException {

        if (!ExHttpUtils.isEmpty(charset)) {
            mCharset = charset;
        }
        mContent = content.getBytes(mCharset);
    }

    @Override
    public long getContentLength() {

        return mContent.length;
    }

    @Override
    public void setContentType(String contentType) {

        if (!ExHttpUtils.isEmpty(contentType)) {
            mContentType = contentType;
        }
    }

    @Override
    public String getContentType() {

        if (!ExHttpUtils.isEmpty(mContentType)) {
            mContentType = "application/json;charset=" + mCharset;
        }

        return mContentType;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {

        if (!ExHttpUtils.isEmpty(mContent)) {
            out.write(mContent);
        }
        out.flush();
    }

}
