/*
 * Copyright (c) 2014 by EagleXad
 * Team: EagleXad
 * Create: 2014-08-29
 */

package com.eaglexad.lib.http.body;

import com.eaglexad.lib.http.tool.ExHttpUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

/**
 * @author Aloneter
 * @ClassName: ExFileBody
 * @Description:
 */
public class ExFileBody extends ExInputStreamBody {

    private File mFile;
    private String mContentType;

    public ExFileBody(File file) throws FileNotFoundException {
        super(new FileInputStream(file));

        mFile = file;
    }

    @Override
    public long getContentLength() {

        return mFile.length();
    }

    @Override
    public void setContentType(String contentType) {

        if (!ExHttpUtils.isEmpty(contentType)) {
            mContentType = contentType;
        }
    }

    @Override
    public String getContentType() {

        if (!ExHttpUtils.isEmpty(mContentType)) {
            mContentType = ExHttpUtils.getFileContentType(mFile);
        }

        return mContentType;
    }

}
