/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Base64;
import android.util.Log;
import com.eaglesakura.android.db.DBOpenType;
import com.eaglesakura.util.ThrowableRunnable;
import com.eaglesakura.util.ThrowableRunner;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TextKeyValueStore
implements Closeable {
    public static final String TABLE_NAME_DEFAULT = "DB_KEY_VALUE_DATA";
    final File dbFile;
    final String tableName;
    final Context context;
    Helper helper;
    SQLiteDatabase db = null;
    static final String DB_KEY = "KEY";
    static final String DB_VALUE = "VALUE";
    static final String DB_DATE = "DATE";
    final String DELETE_TBL_SQL;
    final String CREATE_TBL_SQL;
    final int SUPPORT_DB_VERSION = 1;
    AtomicInteger refs = new AtomicInteger(0);
    public static final InsertFilter FILTER_NEWDATA = new InsertFilter(){

        @Override
        public boolean isOverwrite(String key, String currentValue, long currentDate, String insertValue, long insertDate) {
            return insertDate > currentDate;
        }
    };
    public static final InsertFilter FILTER_OLDDATA = new InsertFilter(){

        @Override
        public boolean isOverwrite(String key, String currentValue, long currentDate, String insertValue, long insertDate) {
            return insertDate < currentDate;
        }
    };
    public static final InsertFilter FILTER_ALWAYS_OVERWRITE = new InsertFilter(){

        @Override
        public boolean isOverwrite(String key, String currentValue, long currentDate, String insertValue, long insertDate) {
            return true;
        }
    };
    public static final InsertFilter FILTER_AYWAYS_NOT_OVERWRITE = new InsertFilter(){

        @Override
        public boolean isOverwrite(String key, String currentValue, long currentDate, String insertValue, long insertDate) {
            return false;
        }
    };
    static final String[] cursorDatas = new String[]{"KEY", "VALUE", "DATE"};

    public TextKeyValueStore(Context context, File dbFile, String tableName) {
        this.context = context;
        this.dbFile = dbFile;
        this.tableName = tableName;
        this.DELETE_TBL_SQL = "DROP TABLE IF EXISTS " + tableName;
        this.CREATE_TBL_SQL = "CREATE TABLE IF NOT EXISTS " + tableName + " (" + DB_KEY + " TEXT PRIMARY KEY NOT NULL UNIQUE , " + DB_VALUE + " TEXT, " + DB_DATE + " INTEGER )";
    }

    public void open(DBOpenType type) {
        if (this.refs.incrementAndGet() == 1) {
            String dbFileName = null;
            if (this.dbFile != null && (dbFileName = this.dbFile.getAbsolutePath()).charAt(1) == ':') {
                dbFileName = this.dbFile.getName();
            }
            this.helper = new Helper(dbFileName);
            this.db = type.open(this.helper);
            this.createTable();
        }
    }

    @Override
    public void close() {
        if (this.refs.decrementAndGet() == 0 && this.helper != null) {
            this.helper.close();
            this.helper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void runInTx(Runnable runnable) {
        try {
            this.db.beginTransaction();
            runnable.run();
        }
        catch (Throwable throwable) {
            try {
                this.db.setTransactionSuccessful();
            }
            catch (Exception exception) {
            }
            finally {
                this.db.endTransaction();
            }
            throw throwable;
        }
        try {
            this.db.setTransactionSuccessful();
        }
        catch (Exception exception) {
        }
        finally {
            this.db.endTransaction();
        }
    }

    public synchronized <RetType, ErrType extends Exception> RetType runInTx(ThrowableRunnable<RetType, ErrType> runnable) throws ErrType {
        ThrowableRunner runner = new ThrowableRunner(runnable);
        this.runInTx((Runnable)runner);
        return (RetType)runner.getOrThrow();
    }

    public void putInTx(Map<String, String> values) {
        this.runInTx(() -> {
            for (Map.Entry entry : values.entrySet()) {
                this.insertOrUpdate((String)entry.getKey(), (String)entry.getValue());
            }
        });
    }

    private ContentValues createValues(String key, String value) {
        if (value == null) {
            value = "";
        }
        ContentValues result = new ContentValues(3);
        result.put(DB_KEY, key);
        result.put(DB_VALUE, value);
        result.put(DB_DATE, Long.valueOf(System.currentTimeMillis()));
        return result;
    }

    public void putDirect(String key, String value) {
        this.runInTx(() -> this.insertOrUpdate(key, value));
    }

    public void insertOrUpdate(String key, String value) {
        ContentValues values = this.createValues(key, value);
        try {
            this.db.insertOrThrow(this.tableName, null, values);
        }
        catch (Exception e) {
            this.db.update(this.tableName, values, "KEY=?", new String[]{key});
        }
    }

    public void update(String key, String value) {
        ContentValues values = this.createValues(key, value);
        this.db.update(this.tableName, values, "KEY='" + key + "'", null);
    }

    private String toString(byte[] buffer) {
        return Base64.encodeToString((byte[])buffer, (int)0);
    }

    public void insert(String key, byte[] buffer) {
        this.insert(key, this.toString(buffer));
    }

    public void insertOrUpdate(String key, byte[] buffer) {
        this.insertOrUpdate(key, this.toString(buffer));
    }

    public void insert(String key, String value) {
        ContentValues values = this.createValues(key, value);
        try {
            this.db.insert(this.tableName, null, values);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void remove(String key) {
        try {
            this.db.delete(this.tableName, "KEY=?", new String[]{key});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Data get(String key) {
        try (Cursor cursor = null;){
            String selection = "KEY=?";
            cursor = this.db.query(this.tableName, cursorDatas, selection, new String[]{key}, null, null, null);
            if (cursor.moveToFirst()) {
                Data data = new Data(cursor);
                return data;
            }
            cursor.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Data> likeKey(String keys) {
        ArrayList<Data> result = new ArrayList<Data>();
        try (Cursor cursor = null;){
            cursor = this.db.query(this.tableName, cursorDatas, String.format("%s LIKE ?", DB_KEY), new String[]{"%%" + keys + "%%"}, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    result.add(new Data(cursor));
                } while (cursor.moveToNext());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Data> list() {
        ArrayList<Data> result = new ArrayList<Data>();
        try (Cursor cursor = null;){
            cursor = this.db.query(this.tableName, cursorDatas, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    result.add(new Data(cursor));
                } while (cursor.moveToNext());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Data> listValues(String value) {
        ArrayList<Data> result = new ArrayList<Data>();
        try (Cursor cursor = null;){
            String selection = "VALUE=?";
            cursor = this.db.query(this.tableName, cursorDatas, selection, new String[]{value}, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    result.add(new Data(cursor));
                } while (cursor.moveToNext());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Data> listTimesUpToDate(long date, int max) {
        LinkedList<Data> result = new LinkedList<Data>();
        try (Cursor cursor = null;){
            String selection = "DATE>=" + date;
            String order = "DATE desc";
            cursor = this.db.query(this.tableName, cursorDatas, selection, null, null, null, order, "" + max);
            if (cursor.moveToFirst()) {
                do {
                    result.add(new Data(cursor));
                } while (cursor.moveToNext());
            }
        }
        return result;
    }

    public String get(String key, String _def) {
        String result = this.getOrNull(key);
        if (result == null) {
            return _def;
        }
        return result;
    }

    public int getInteger(String key, int def) {
        return (int)this.getLong(key, def);
    }

    public long getLong(String key, long def) {
        String value = this.get(key, null);
        if (value != null) {
            return Long.parseLong(value);
        }
        return def;
    }

    public float getFloat(String key, float def) {
        String value = this.get(key, null);
        if (value != null) {
            return Float.parseFloat(value);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOrNull(String key) {
        try (Cursor cursor = null;){
            String selection = "KEY=?";
            cursor = this.db.query(this.tableName, new String[]{DB_VALUE}, selection, new String[]{key}, null, null, null);
            cursor.moveToFirst();
            String string = cursor.getString(0);
            return string;
        }
    }

    public boolean exists(String key) {
        return this.get(key, null) != null;
    }

    private void dropTable() {
        this.db.execSQL(this.DELETE_TBL_SQL);
        this.createTable();
    }

    private void createTable() {
        this.db.execSQL(this.CREATE_TBL_SQL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _insert(String key, String insertValue, long insertDate, InsertFilter filter) throws Exception {
        ContentValues values = this.createValues(key, insertValue);
        values.put(DB_DATE, Long.valueOf(insertDate));
        if (!this.exists(key)) {
            this.db.insert(this.tableName, null, values);
            return;
        }
        try (Cursor cursor = this.db.query(this.tableName, new String[]{DB_VALUE, DB_DATE}, "KEY='" + key + "'", null, null, null, null);){
            cursor.moveToFirst();
            String currentValue = cursor.getString(0);
            long currentDate = cursor.getLong(1);
            if (filter.isOverwrite(key, currentValue, currentDate, insertValue, insertDate)) {
                this.remove(key);
                this.db.insert(this.tableName, null, values);
            }
        }
    }

    public void insertTo(final TextKeyValueStore insertDB, final InsertFilter filter) {
        this.runInTx(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try (Cursor cursor = insertDB.db.query(TextKeyValueStore.this.tableName, new String[]{TextKeyValueStore.DB_KEY, TextKeyValueStore.DB_VALUE, TextKeyValueStore.DB_DATE}, null, null, null, null, null);){
                    if (cursor.moveToFirst()) {
                        do {
                            String key = cursor.getString(0);
                            String value = cursor.getString(1);
                            long date = cursor.getLong(2);
                            try {
                                TextKeyValueStore.this._insert(key, value, date, filter);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } while (cursor.moveToNext());
                    }
                }
            }
        });
    }

    @Deprecated
    public void print() {
        String selection = null;
        Cursor cursor = this.db.query(this.tableName, new String[]{DB_KEY, DB_VALUE}, selection, null, null, null, null);
        cursor.moveToFirst();
        do {
            String key = cursor.getString(0);
            String value = cursor.getString(1);
            Log.d((String)"KVS", (String)(key + " :: " + value));
        } while (cursor.moveToNext());
    }

    public static class Data {
        public final String value;
        public final long date;
        public final String key;

        private Data(Cursor cursor) {
            this.key = cursor.getString(0);
            this.value = cursor.getString(1);
            this.date = cursor.getLong(2);
        }

        public byte[] valueToByteArray() {
            return Base64.decode((String)this.value, (int)0);
        }
    }

    public static interface InsertFilter {
        public boolean isOverwrite(String var1, String var2, long var3, String var5, long var6);
    }

    class Helper
    extends SQLiteOpenHelper {
        public Helper(String dbFileName) {
            super(TextKeyValueStore.this.context, dbFileName, null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL(TextKeyValueStore.this.CREATE_TBL_SQL);
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.execSQL(TextKeyValueStore.this.DELETE_TBL_SQL);
            db.execSQL(TextKeyValueStore.this.CREATE_TBL_SQL);
        }
    }
}

