/*
 * Decompiled with CFR 0.152.
 */
package com.eaglesakura.android.service;

import android.app.Service;
import android.os.IBinder;
import android.os.RemoteException;
import com.eaglesakura.android.service.aidl.ICommandClientCallback;
import com.eaglesakura.android.service.aidl.ICommandServerService;
import com.eaglesakura.android.service.data.Payload;
import com.eaglesakura.android.thread.UIHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CommandServer {
    protected final Service mService;
    private final ICommandServerService mImpl;
    private Map<String, ServiceClient> mClients = new HashMap<String, ServiceClient>();

    public CommandServer(Service service) {
        this.mService = service;
        this.mImpl = new ServerImpl();
    }

    public Service getService() {
        return this.mService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientNum() {
        Map<String, ServiceClient> map = this.mClients;
        synchronized (map) {
            return this.mClients.size();
        }
    }

    public IBinder getBinder() {
        if (this.mImpl instanceof ICommandServerService.Stub) {
            return (ICommandServerService.Stub)this.mImpl;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasClient(String id) {
        Map<String, ServiceClient> map = this.mClients;
        synchronized (map) {
            return this.mClients.containsKey(id);
        }
    }

    protected void onRegisterClient(String id, ICommandClientCallback callback) {
    }

    protected void onUnregisterClient(String id) {
    }

    protected Payload postToClient(String clientId, String cmd, byte[] buffer) throws RemoteException {
        return this.postToClient(clientId, cmd, new Payload(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Payload postToClient(String clientId, String cmd, Payload payload) throws RemoteException {
        ServiceClient client;
        Map<String, ServiceClient> map = this.mClients;
        synchronized (map) {
            client = this.mClients.get(clientId);
        }
        if (client != null) {
            return client.callback.postToClient(cmd, payload);
        }
        return null;
    }

    protected void broadcastToClientNoResults(String cmd, byte[] buffer) throws RemoteException {
        this.broadcastToClientNoResults(cmd, new Payload(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastToClientNoResults(String cmd, Payload payload) throws RemoteException {
        HashMap<String, ServiceClient> clients;
        Map<String, ServiceClient> map = this.mClients;
        synchronized (map) {
            clients = new HashMap<String, ServiceClient>(this.mClients);
        }
        for (Map.Entry entry : clients.entrySet()) {
            ((ServiceClient)entry.getValue()).callback.postToClient(cmd, payload);
        }
    }

    protected void broadcastToClient(String cmd, byte[] buffer, ClientResultCallback callback) throws RemoteException {
        this.broadcastToClient(cmd, new Payload(buffer), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastToClient(String cmd, Payload payload, ClientResultCallback callback) throws RemoteException {
        HashMap<String, ServiceClient> clients;
        Map<String, ServiceClient> map = this.mClients;
        synchronized (map) {
            clients = new HashMap<String, ServiceClient>(this.mClients);
        }
        for (Map.Entry entry : clients.entrySet()) {
            ServiceClient client = (ServiceClient)entry.getValue();
            Payload clientResult = client.callback.postToClient(cmd, payload);
            callback.onClientExecuted(client.id, client.callback, cmd, clientResult);
        }
    }

    protected Map<String, Payload> broadcastToClient(String cmd, byte[] buffer) throws RemoteException {
        return this.broadcastToClient(cmd, new Payload(buffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Payload> broadcastToClient(String cmd, Payload payload) throws RemoteException {
        HashMap<String, ServiceClient> clients;
        Map<String, ServiceClient> map = this.mClients;
        synchronized (map) {
            clients = new HashMap<String, ServiceClient>(this.mClients);
        }
        HashMap<String, Payload> results = new HashMap<String, Payload>();
        for (Map.Entry entry : clients.entrySet()) {
            results.put((String)entry.getKey(), ((ServiceClient)entry.getValue()).callback.postToClient(cmd, payload));
        }
        return results;
    }

    protected Payload onReceivedDataFromClient(String cmd, String clientId, Payload payload) throws RemoteException {
        return null;
    }

    private class ServiceClient {
        final String id;
        final ICommandClientCallback callback;

        public ServiceClient(String id, ICommandClientCallback callback) {
            this.id = id;
            this.callback = callback;
        }
    }

    public static interface ClientResultCallback {
        public void onClientExecuted(String var1, ICommandClientCallback var2, String var3, Payload var4);
    }

    private class ServerImpl
    extends ICommandServerService.Stub {
        private ServerImpl() {
        }

        @Override
        public Payload postToServer(String cmd, String clientId, Payload payload) throws RemoteException {
            return CommandServer.this.onReceivedDataFromClient(cmd, clientId, payload);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerCallback(final String id, final ICommandClientCallback callback) throws RemoteException {
            Map map = CommandServer.this.mClients;
            synchronized (map) {
                ServiceClient client = new ServiceClient(id, callback);
                CommandServer.this.mClients.put(id, client);
            }
            UIHandler.postUI((Runnable)new Runnable(){

                @Override
                public void run() {
                    CommandServer.this.onRegisterClient(id, callback);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterCallback(ICommandClientCallback callback) throws RemoteException {
            final ArrayList idList = new ArrayList();
            Map map = CommandServer.this.mClients;
            synchronized (map) {
                Iterator iterator = CommandServer.this.mClients.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item = iterator.next();
                    if (callback != ((ServiceClient)item.getValue()).callback) continue;
                    idList.add(item.getKey());
                    iterator.remove();
                }
            }
            UIHandler.postUI((Runnable)new Runnable(){

                @Override
                public void run() {
                    for (String id : idList) {
                        CommandServer.this.onUnregisterClient(id);
                    }
                }
            });
        }
    }
}

