/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBasedRepositoryMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.eclipse.aether.DefaultRepositoryCache;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryCache;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="update-stage-dependencies", defaultPhase=LifecyclePhase.INITIALIZE)
public class UpdateStageDependenciesMojo
extends AbstractGitflowBasedRepositoryMojo {
    @Component
    ProjectDependenciesResolver dependenciesResolver;

    @Override
    protected void execute(GitBranchInfo branchInfo) throws MojoExecutionException, MojoFailureException {
        this.getLog().debug((CharSequence)"update-stage-dependencies setting up Repository session...");
        DefaultRepositorySystemSession reresolveSession = new DefaultRepositorySystemSession(this.repositorySystemSession);
        reresolveSession.setUpdatePolicy("always");
        reresolveSession.setCache((RepositoryCache)new DefaultRepositoryCache());
        LocalRepositoryManager localRepositoryManager = reresolveSession.getLocalRepositoryManager();
        this.getLog().debug((CharSequence)"configuring stage as the remote repository for artifact resolution requests...");
        List<RemoteRepository> stageRepo = Arrays.asList(RepositoryUtils.toRepo((ArtifactRepository)this.getDeploymentRepository(this.stageDeploymentRepository)));
        boolean itemsPurged = false;
        try {
            DependencyResolutionResult depencencyResult = this.dependenciesResolver.resolve((DependencyResolutionRequest)new DefaultDependencyResolutionRequest(this.project, (RepositorySystemSession)reresolveSession));
            for (Dependency dependency : depencencyResult.getResolvedDependencies()) {
                LocalArtifactResult localResult;
                if (dependency.getArtifact().isSnapshot() || (localResult = localRepositoryManager.find((RepositorySystemSession)reresolveSession, new LocalArtifactRequest(dependency.getArtifact(), stageRepo, null))).getFile() == null || localResult.getRepository() == null) continue;
                this.getLog().info((CharSequence)("Purging: " + dependency + " from remote repository: " + localResult.getRepository() + "."));
                File deleteTarget = new File(localRepositoryManager.getRepository().getBasedir(), localRepositoryManager.getPathForLocalArtifact(dependency.getArtifact()));
                if (deleteTarget.isDirectory()) {
                    try {
                        FileUtils.deleteDirectory((File)deleteTarget);
                    }
                    catch (IOException ioe) {
                        this.getLog().warn((CharSequence)("Failed to purge stage artifact from local repository: " + deleteTarget), (Throwable)ioe);
                    }
                } else if (!deleteTarget.delete()) {
                    this.getLog().warn((CharSequence)("Failed to purge stage artifact from local repository: " + deleteTarget));
                }
                itemsPurged = true;
            }
        }
        catch (DependencyResolutionException dre) {
            throw new MojoExecutionException("Initial dependency resolution to resolve dependencies which may have been provided by the 'stage' repository failed.", (Exception)((Object)dre));
        }
        if (itemsPurged) {
            try {
                this.getLog().info((CharSequence)"Resolving purged dependencies...");
                this.dependenciesResolver.resolve((DependencyResolutionRequest)new DefaultDependencyResolutionRequest(this.project, (RepositorySystemSession)reresolveSession));
                this.getLog().info((CharSequence)"All stage dependencies purged and re-resolved.");
            }
            catch (DependencyResolutionException e) {
                throw new MojoExecutionException("Post-purge dependency resolution failed!", (Exception)((Object)e));
            }
        }
    }
}

