/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.AbstractGitflowBasedRepositoryMojo;
import com.e_gineering.maven.gitflowhelper.GitBranchInfo;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="retarget-deploy", defaultPhase=LifecyclePhase.VALIDATE)
public class RetargetDeployMojo
extends AbstractGitflowBasedRepositoryMojo {
    @Override
    protected void execute(GitBranchInfo gitBranchInfo) throws MojoExecutionException, MojoFailureException {
        if (this.project.getDistributionManagement() == null) {
            this.project.setDistributionManagement(new DistributionManagement());
        }
        switch (gitBranchInfo.getType()) {
            case SUPPORT: 
            case MASTER: {
                this.setTargetRelease();
                break;
            }
            case RELEASE: 
            case HOTFIX: {
                this.setTargetStage();
                break;
            }
            case DEVELOPMENT: {
                this.setTargetSnapshots();
                break;
            }
            case OTHER: {
                String otherBranchesToDeploy = this.resolveExpression(this.otherDeployBranchPattern);
                if (!"".equals(otherBranchesToDeploy) && gitBranchInfo.getName().matches(otherBranchesToDeploy)) {
                    this.setTargetSnapshots();
                    this.project.setVersion(this.getAsBranchSnapshotVersion(this.project.getVersion(), gitBranchInfo.getName()));
                    this.updateArtifactVersion(this.project.getArtifact(), gitBranchInfo.getName());
                    for (Artifact a : this.project.getAttachedArtifacts()) {
                        this.updateArtifactVersion(a, gitBranchInfo.getName());
                    }
                    this.getLog().info((CharSequence)("Artifact versions updated with build metadata: " + this.getAsBranchSnapshotVersion("", gitBranchInfo.getName())));
                    break;
                }
            }
            default: {
                this.unsetRepos();
            }
        }
    }

    private void updateArtifactVersion(Artifact a, String branchName) {
        if (a != null) {
            a.setVersion(this.getAsBranchSnapshotVersion(a.getVersion(), branchName));
            try {
                a.setVersionRange(VersionRange.createFromVersion((String)a.getVersion()));
            }
            catch (UnsupportedOperationException uoe) {
                this.getLog().debug((CharSequence)"Unable to update VersionRange for artifact.");
            }
        }
    }

    private String getAsBranchSnapshotVersion(String version, String branchName) {
        return version.replace("-SNAPSHOT", "") + this.otherBranchVersionDelimiter + branchName.replaceAll("[^0-9A-Za-z-.]", "-") + "-SNAPSHOT";
    }

    private void setTargetSnapshots() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Setting snapshot artifact repository to: [" + this.snapshotDeploymentRepository + "]"));
        this.project.setSnapshotArtifactRepository(this.getDeploymentRepository(this.snapshotDeploymentRepository));
        this.project.setReleaseArtifactRepository(null);
    }

    private void setTargetStage() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Setting release artifact repository to: [" + this.stageDeploymentRepository + "]"));
        this.project.setSnapshotArtifactRepository(null);
        this.project.setReleaseArtifactRepository(this.getDeploymentRepository(this.stageDeploymentRepository));
    }

    private void setTargetRelease() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Setting release artifact repository to: [" + this.releaseDeploymentRepository + "]"));
        this.project.setSnapshotArtifactRepository(null);
        this.project.setReleaseArtifactRepository(this.getDeploymentRepository(this.releaseDeploymentRepository));
    }

    private void unsetRepos() {
        this.getLog().info((CharSequence)"Un-Setting artifact repositories.");
        this.project.setSnapshotArtifactRepository(null);
        this.project.setReleaseArtifactRepository(null);
        this.project.getProperties().put("maven.deploy.skip", "true");
        this.getLog().info((CharSequence)"Setting maven.deploy.skip = 'true'");
    }
}

