/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.GitBranchInfo;
import com.e_gineering.maven.gitflowhelper.GitBranchType;
import com.e_gineering.maven.gitflowhelper.PlexusLoggerToMavenLog;
import com.e_gineering.maven.gitflowhelper.ScmUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.prefix.NoPluginFoundForPrefixException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.ScmManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="promote-master")
public class MasterPromoteExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private MojoDescriptorCreator descriptorCreator;
    @Requirement
    private Logger logger;
    @Requirement
    private ScmManager scmManager;

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Properties systemEnvVars = null;
        try {
            systemEnvVars = CommandLineUtils.getSystemEnvVars();
        }
        catch (IOException ioe) {
            throw new MavenExecutionException("Unable to read System Envirionment Variables: ", (Throwable)ioe);
        }
        String masterBranchPattern = null;
        String supportBranchPattern = null;
        String releaseBranchPattern = null;
        String hotfixBranchPattern = null;
        String developmentBranchPattern = null;
        String featureOrBugfixBranchPattern = null;
        String gitBranchExpression = null;
        boolean pluginFound = false;
        ArrayList<Plugin> pluginsToRetain = new ArrayList<Plugin>(session.getGoals().size());
        List goals = session.getGoals();
        for (Object goal : goals) {
            int delimiter = ((String)goal).indexOf(":");
            if (delimiter == -1) continue;
            String prefix = ((String)goal).substring(0, delimiter);
            try {
                pluginsToRetain.add(this.descriptorCreator.findPluginForPrefix(prefix, session));
            }
            catch (NoPluginFoundForPrefixException ex) {
                this.logger.warn("gitflow-helper-maven-plugin: Unable to resolve project plugin for prefix: " + prefix + " for goal: " + (String)goal);
            }
        }
        HashMap pluginsToDrop = new HashMap();
        for (MavenProject project : session.getProjects()) {
            ArrayList<Plugin> dropPlugins = new ArrayList<Plugin>();
            for (Plugin plugin : project.getModel().getBuild().getPlugins()) {
                if (plugin.getKey().equals("com.e-gineering:gitflow-helper-maven-plugin")) {
                    pluginFound = true;
                    this.logger.debug("gitflow-helper-maven-plugin found in project: [" + project.getName() + "]");
                    if (masterBranchPattern == null) {
                        masterBranchPattern = this.extractPluginConfigValue("masterBranchPattern", plugin);
                    }
                    if (supportBranchPattern == null) {
                        supportBranchPattern = this.extractPluginConfigValue("supportBranchPattern", plugin);
                    }
                    if (releaseBranchPattern == null) {
                        releaseBranchPattern = this.extractPluginConfigValue("releaseBranchPattern", plugin);
                    }
                    if (hotfixBranchPattern == null) {
                        hotfixBranchPattern = this.extractPluginConfigValue("hotfixBranchPattern", plugin);
                    }
                    if (developmentBranchPattern == null) {
                        developmentBranchPattern = this.extractPluginConfigValue("developmentBranchPattern", plugin);
                    }
                    if (featureOrBugfixBranchPattern == null) {
                        featureOrBugfixBranchPattern = this.extractPluginConfigValue("featureOrBugfixBranchPattern", plugin);
                    }
                    if (gitBranchExpression != null) continue;
                    gitBranchExpression = this.extractPluginConfigValue("gitBranchExpression", plugin);
                    continue;
                }
                if (pluginsToRetain.contains(plugin)) {
                    this.logger.debug("gitflow-helper-maven-plugin retaining plugin: " + plugin + " from project: " + project.getName());
                    continue;
                }
                if (plugin.getKey().equals("org.apache.maven.plugins:maven-deploy-plugin")) {
                    this.logger.debug("gitflow-helper-maven-plugin retaining plugin: " + plugin + " from project: " + project.getName());
                    continue;
                }
                this.logger.debug("gitflow-helper-maven-plugin removing plugin: " + plugin + " from project: " + project.getName());
                dropPlugins.add(plugin);
            }
            pluginsToDrop.put(project, dropPlugins);
        }
        if (pluginFound) {
            if (masterBranchPattern == null) {
                this.logger.debug("Using default master branch Pattern.");
                masterBranchPattern = "(origin/)?master";
            }
            this.logger.debug("Master Branch Pattern: " + masterBranchPattern);
            if (supportBranchPattern == null) {
                this.logger.debug("Using default support branch Pattern.");
                supportBranchPattern = "(origin/)?support/(.*)";
            }
            this.logger.debug("Support Branch Pattern: " + supportBranchPattern);
            if (releaseBranchPattern == null) {
                this.logger.debug("Using default release branch Pattern.");
                releaseBranchPattern = "(origin/)?release/(.*)";
            }
            this.logger.debug("Release Branch Pattern: " + releaseBranchPattern);
            if (hotfixBranchPattern == null) {
                this.logger.debug("Using default hotfix branch Pattern.");
                hotfixBranchPattern = "(origin/)?hotfix/(.*)";
            }
            this.logger.debug("Hotfix Branch Pattern: " + hotfixBranchPattern);
            if (developmentBranchPattern == null) {
                this.logger.debug("Using default development Pattern.");
                developmentBranchPattern = "(origin/)?develop";
            }
            this.logger.debug("Development Branch Pattern: " + developmentBranchPattern);
            if (featureOrBugfixBranchPattern == null) {
                this.logger.debug("Using default feature or bugfix Pattern.");
                featureOrBugfixBranchPattern = "(origin/)?(?:feature|bugfix)/(.*)";
            }
            this.logger.debug("Feature or Bugfix Branch Pattern: " + featureOrBugfixBranchPattern);
            ScmUtils scmUtils = new ScmUtils(systemEnvVars, this.scmManager, session.getTopLevelProject(), new PlexusLoggerToMavenLog(this.logger), masterBranchPattern, supportBranchPattern, releaseBranchPattern, hotfixBranchPattern, developmentBranchPattern);
            GitBranchInfo branchInfo = scmUtils.resolveBranchInfo(gitBranchExpression);
            boolean pruneBuild = false;
            if (branchInfo != null) {
                this.logger.info(branchInfo.toString());
                if (branchInfo.getType().equals((Object)GitBranchType.MASTER)) {
                    this.logger.info("gitflow-helper-maven-plugin: Enabling MasterPromoteExtension. GIT_BRANCH: [" + branchInfo.getName() + "] matches masterBranchPattern: [" + masterBranchPattern + "]");
                    pruneBuild = true;
                } else if (branchInfo.getType().equals((Object)GitBranchType.SUPPORT)) {
                    this.logger.info("gitflow-helper-maven-plugin: Enabling MasterPromoteExtension. GIT_BRANCH: [" + branchInfo.getName() + "] matches supportBranchPattern: [" + supportBranchPattern + "]");
                    pruneBuild = true;
                }
            } else {
                this.logger.warn("Can't determine the Git branch. Not disabling any plugins.");
            }
            if (pruneBuild) {
                for (MavenProject project : session.getProjects()) {
                    project.getModel().getBuild().getPlugins().removeAll((Collection)pluginsToDrop.get(project));
                }
            }
        }
    }

    private String extractPluginConfigValue(String parameter, Plugin plugin) {
        String value = this.extractConfigValue(parameter, plugin.getConfiguration());
        for (int i = 0; i < plugin.getExecutions().size() && value == null; ++i) {
            value = this.extractConfigValue(parameter, ((PluginExecution)plugin.getExecutions().get(i)).getConfiguration());
        }
        return value;
    }

    private String extractConfigValue(String parameter, Object configuration) {
        try {
            return ((Xpp3Dom)configuration).getChild(parameter).getValue();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

