/*
 * Decompiled with CFR 0.152.
 */
package com.e_gineering.maven.gitflowhelper;

import com.e_gineering.maven.gitflowhelper.GitBranchInfo;
import com.e_gineering.maven.gitflowhelper.ScmUtils;
import com.e_gineering.maven.gitflowhelper.properties.PropertyResolver;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.ScmManager;
import org.codehaus.plexus.util.cli.CommandLineUtils;

public abstract class AbstractGitflowBranchMojo
extends AbstractMojo {
    private Properties systemEnvVars = new Properties();
    @Component
    protected ScmManager scmManager;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="(origin/)?master", property="masterBranchPattern", required=true)
    private String masterBranchPattern;
    @Parameter(defaultValue="(origin/)?support/(.*)", property="supportBranchPattern", required=true)
    private String supportBranchPattern;
    @Parameter(defaultValue="(origin/)?release/(.*)", property="releaseBranchPattern", required=true)
    private String releaseBranchPattern;
    @Parameter(defaultValue="(origin/)?hotfix/(.*)", property="hotfixBranchPattern", required=true)
    private String hotfixBranchPattern;
    @Parameter(defaultValue="(origin/)?develop", property="developmentBranchPattern", required=true)
    private String developmentBranchPattern;
    @Parameter(property="gitBranchExpression", required=false)
    private String gitBranchExpression;
    @Parameter(defaultValue="equals", property="releaseBranchMatchType", required=true)
    String releaseBranchMatchType;

    protected String resolveExpression(String expression) {
        return PropertyResolver.resolveValue(expression, this.project.getProperties(), this.systemEnvVars);
    }

    protected abstract void execute(GitBranchInfo var1) throws MojoExecutionException, MojoFailureException;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.systemEnvVars = CommandLineUtils.getSystemEnvVars();
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to read System Envirionment Variables: ", (Exception)ioe);
        }
        this.checkReleaseBranchMatchTypeParam();
        ScmUtils scmUtils = new ScmUtils(this.systemEnvVars, this.scmManager, this.project, this.getLog(), this.masterBranchPattern, this.supportBranchPattern, this.releaseBranchPattern, this.hotfixBranchPattern, this.developmentBranchPattern);
        GitBranchInfo branchInfo = scmUtils.resolveBranchInfo(this.gitBranchExpression);
        this.getLog().debug((CharSequence)("Building for: " + branchInfo));
        this.execute(branchInfo);
    }

    private void checkReleaseBranchMatchTypeParam() throws MojoFailureException {
        if (!"equals".equals(this.releaseBranchMatchType) && !"startsWith".equals(this.releaseBranchMatchType)) {
            throw new MojoFailureException("'releaseBranchMatchType' should be either 'equals' or 'startsWith'. Found '" + this.releaseBranchMatchType + "'.");
        }
    }
}

