/*
 * Decompiled with CFR 0.152.
 */
package com.dzaitsev.android.widget;

import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.util.DisplayMetrics;
import android.util.TypedValue;

final class Utils {
    Utils() {
    }

    @NonNull
    static Paint createPaint(int color) {
        Paint paint = new Paint(1);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(color);
        return paint;
    }

    static void mutatePaint(Paint paint, int color, float strokeWidth, Paint.Style style) {
        paint.setColor(color);
        paint.setStrokeWidth(strokeWidth);
        paint.setStyle(style);
    }

    static int gradient(int startColor, int endColor, int factor, int steps) {
        int alpha = Utils.between(Color.alpha((int)startColor), Color.alpha((int)endColor), factor, steps);
        int red = Utils.between(Color.red((int)startColor), Color.red((int)endColor), factor, steps);
        int green = Utils.between(Color.green((int)startColor), Color.green((int)endColor), factor, steps);
        int blue = Utils.between(Color.blue((int)startColor), Color.blue((int)endColor), factor, steps);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    @NonNull
    static float[] createPoint(float radius, double alpha, float x0, float y0) {
        float[] point = new float[]{(float)((double)radius * StrictMath.cos(alpha) + (double)x0), (float)((double)radius * StrictMath.sin(alpha) + (double)y0)};
        return point;
    }

    @NonNull
    static float[] createPoints(int count, float radius, float x0, float y0) {
        int length = count + count;
        float[] points = new float[length];
        double angle = Math.PI * 2 / (double)count;
        int j = 0;
        for (int i = 0; i < length; i += 2) {
            double alpha = angle * (double)j++ - 1.5707963267948966;
            float[] point = Utils.createPoint(radius, alpha, x0, y0);
            points[i] = point[0];
            points[i + 1] = point[1];
        }
        return points;
    }

    static int dp(float dp, DisplayMetrics metrics) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)metrics);
    }

    static int sp(float sp, DisplayMetrics metrics) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)metrics);
    }

    private static int between(int startColor, int endColor, int factor, int steps) {
        float ratio = (float)factor / (float)steps;
        return (int)((float)endColor * ratio + (float)startColor * (1.0f - ratio));
    }
}

