/*
 * Decompiled with CFR 0.152.
 */
package com.dzaitsev.android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import com.dzaitsev.android.widget.R;
import com.dzaitsev.android.widget.Utils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class RadarChartView
extends View {
    private int startColor;
    private int endColor;
    private int axisColor;
    private float axisMax;
    private float axisTick;
    private int axisWidth;
    private int chartColor;
    private int chartWidth;
    private Paint.Style chartStyle;
    private boolean circlesOnly;
    private boolean autoSize;
    private boolean smoothGradient;
    private final LinkedHashMap<String, Float> axis = new LinkedHashMap();
    private final Rect rect = new Rect();
    private final Path path = new Path();
    private final TextPaint textPaint = new TextPaint(1);
    private final Paint paint = Utils.createPaint(-16777216);
    private int centerX;
    private int centerY;
    private Ring[] rings;
    private float[] vertices;
    private float ratio;
    private float axisMaxInternal;
    private float axisTickInternal;

    public RadarChartView(Context context) {
        this(context, null);
    }

    public RadarChartView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RadarChartView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray colors = context.obtainStyledAttributes(attrs, new int[]{R.attr.colorAccent, R.attr.colorPrimary, R.attr.colorPrimaryDark}, defStyleAttr, 0);
        int colorAccent = colors.getColor(0, Color.parseColor((String)"#22737b"));
        int colorPrimary = colors.getColor(1, Color.parseColor((String)"#c3e3e5"));
        int colorPrimaryDark = colors.getColor(2, Color.parseColor((String)"#5f9ca1"));
        colors.recycle();
        TypedArray values = context.obtainStyledAttributes(attrs, R.styleable.RadarChartView, defStyleAttr, 0);
        this.startColor = values.getColor(R.styleable.RadarChartView_startColor, colorPrimaryDark);
        this.endColor = values.getColor(R.styleable.RadarChartView_endColor, colorPrimary);
        this.axisColor = values.getColor(R.styleable.RadarChartView_axisColor, -16777216);
        this.axisMax = values.getFloat(R.styleable.RadarChartView_axisMax, 20.0f);
        this.axisTick = values.getFloat(R.styleable.RadarChartView_axisTick, this.axisMax / 5.0f);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        int textSize = values.getDimensionPixelSize(R.styleable.RadarChartView_textSize, Utils.sp(15.0f, metrics));
        this.circlesOnly = values.getBoolean(R.styleable.RadarChartView_circlesOnly, false);
        this.autoSize = values.getBoolean(R.styleable.RadarChartView_autoSize, true);
        this.axisWidth = values.getDimensionPixelSize(R.styleable.RadarChartView_axisWidth, Utils.dp(1.0f, metrics));
        this.chartColor = values.getColor(R.styleable.RadarChartView_chartColor, colorAccent);
        this.chartWidth = values.getDimensionPixelSize(R.styleable.RadarChartView_chartWidth, Utils.dp(3.0f, metrics));
        this.chartStyle = Paint.Style.values()[values.getInt(R.styleable.RadarChartView_chartStyle, Paint.Style.STROKE.ordinal())];
        this.smoothGradient = values.getBoolean(R.styleable.RadarChartView_smoothGradient, false);
        values.recycle();
        this.textPaint.setTextSize((float)textSize);
        this.textPaint.density = metrics.density;
    }

    public final void addOrReplace(String axisName, float value) {
        this.axis.put(axisName, Float.valueOf(value));
        this.onAxisChanged();
    }

    public final void clearAxis() {
        this.axis.clear();
        this.onAxisChanged();
    }

    public final Map<String, Float> getAxis() {
        return Collections.unmodifiableMap(this.axis);
    }

    public final void setAxis(Map<String, Float> axis) {
        this.axis.clear();
        this.axis.putAll(axis);
        this.onAxisChanged();
    }

    public final int getAxisColor() {
        return this.axisColor;
    }

    public final void setAxisColor(int axisColor) {
        this.axisColor = axisColor;
        this.invalidate();
    }

    public final float getAxisMax() {
        return this.axisMax;
    }

    public final void setAxisMax(float axisMax) {
        this.setAutoSize(false);
        this.setAxisMaxInternal(axisMax);
    }

    public final float getAxisTick() {
        return this.axisTick;
    }

    public final void setAxisTick(float axisTick) {
        this.axisTick = axisTick;
        this.calcAxisTickInternal();
        this.buildRings();
        this.invalidate();
    }

    public final float getAxisWidth() {
        return this.axisWidth;
    }

    public final void setAxisWidth(int axisWidth) {
        this.axisWidth = axisWidth;
        this.invalidate();
    }

    public final int getChartColor() {
        return this.chartColor;
    }

    public final void setChartColor(int chartColor) {
        this.chartColor = chartColor;
        this.invalidate();
    }

    public final Paint.Style getChartStyle() {
        return this.chartStyle;
    }

    public final void setChartStyle(Paint.Style chartStyle) {
        this.chartStyle = chartStyle;
        this.invalidate();
    }

    public final float getChartWidth() {
        return this.chartWidth;
    }

    public final void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
        this.invalidate();
    }

    public final int getEndColor() {
        return this.endColor;
    }

    public final void setEndColor(int endColor) {
        this.endColor = endColor;
        this.invalidate();
        this.invalidate();
    }

    public final int getStartColor() {
        return this.startColor;
    }

    public final void setStartColor(int startColor) {
        this.startColor = startColor;
        this.invalidate();
    }

    public final boolean isAutoSize() {
        return this.autoSize;
    }

    public final void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        if (autoSize && !this.axis.isEmpty()) {
            this.setAxisMaxInternal(Collections.max(this.axis.values()).floatValue());
        }
    }

    public final boolean isCirclesOnly() {
        return this.circlesOnly;
    }

    public final void setCirclesOnly(boolean circlesOnly) {
        this.circlesOnly = circlesOnly;
        this.invalidate();
    }

    public final boolean isSmoothGradient() {
        return this.smoothGradient;
    }

    public final void setSmoothGradient(boolean smoothGradient) {
        this.smoothGradient = smoothGradient;
        this.invalidate();
    }

    public final void remove(String axisName) {
        this.axis.remove(axisName);
        this.onAxisChanged();
    }

    public final void setTextSize(float textSize) {
        this.textPaint.setTextSize(textSize);
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.calculateCenter();
        this.axisMaxInternal = (float)StrictMath.max(0, StrictMath.min(this.getMeasuredWidth() - this.getPaddingRight() - this.getPaddingLeft(), this.getMeasuredHeight() - this.getPaddingBottom() - this.getPaddingTop())) * 0.5f;
        this.calcRatio();
        this.calcAxisTickInternal();
        this.buildRings();
    }

    protected void onDraw(Canvas canvas) {
        int count = this.axis.size();
        if (count < 3 || this.circlesOnly) {
            this.drawCircles(canvas);
        } else {
            this.drawPolygons(canvas, count);
        }
        this.drawValues(canvas, count);
        this.drawAxis(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (width != (height = View.MeasureSpec.getSize((int)heightMeasureSpec))) {
            int size = View.MeasureSpec.makeMeasureSpec((int)StrictMath.min(width, height), (int)0x40000000);
            super.onMeasure(size, size);
        }
    }

    private void buildRings() {
        int ringsCount = (int)StrictMath.max(StrictMath.ceil(this.axisMaxInternal / this.axisTickInternal), 1.0);
        if (ringsCount == 0) {
            return;
        }
        this.rings = new Ring[ringsCount];
        if (ringsCount == 1) {
            this.rings[0] = new Ring(this.axisMaxInternal, this.axisMaxInternal, this.startColor);
        } else {
            for (int i = 0; i < ringsCount; ++i) {
                this.rings[i] = new Ring(this.axisTickInternal * (float)(i + 1), this.axisTickInternal, Utils.gradient(this.startColor, this.endColor, i, ringsCount));
            }
            this.rings[ringsCount - 1] = new Ring(this.axisMaxInternal, this.axisMaxInternal - this.rings[ringsCount - 2].radius, this.endColor);
        }
        this.buildVertices();
    }

    private void buildVertices() {
        int count = this.axis.size();
        for (Ring ring : this.rings) {
            ring.vertices = Utils.createPoints(count, ring.fixedRadius, this.centerX, this.centerY);
        }
        this.vertices = Utils.createPoints(count, this.axisMaxInternal, this.centerX, this.centerY);
    }

    private void calcAxisTickInternal() {
        this.axisTickInternal = this.axisTick * this.ratio;
    }

    private void calcRatio() {
        this.ratio = this.axisMaxInternal > 0.0f ? this.axisMaxInternal / this.axisMax : 1.0f;
    }

    private void calculateCenter() {
        this.centerX = (this.getMeasuredWidth() >> 1) + this.getPaddingLeft() - this.getPaddingRight();
        this.centerY = (this.getMeasuredHeight() >> 1) + this.getPaddingTop() - this.getPaddingBottom();
    }

    private void drawAxis(Canvas canvas) {
        Iterator<String> axisNames = this.axis.keySet().iterator();
        Utils.mutatePaint(this.paint, this.axisColor, this.axisWidth, Paint.Style.STROKE);
        int length = this.vertices.length;
        for (int i = 0; i < length; i += 2) {
            this.path.reset();
            this.path.moveTo((float)this.centerX, (float)this.centerY);
            float pointX = this.vertices[i];
            float pointY = this.vertices[i + 1];
            this.path.lineTo(pointX, pointY);
            this.path.close();
            canvas.drawPath(this.path, this.paint);
            String axisName = axisNames.next();
            this.textPaint.getTextBounds(axisName, 0, axisName.length(), this.rect);
            float x = pointX > (float)this.centerX ? pointX : pointX - (float)this.rect.width();
            float y = pointY > (float)this.centerY ? pointY + (float)this.rect.height() : pointY;
            canvas.drawText(axisName, x, y, (Paint)this.textPaint);
        }
    }

    private void drawCircles(Canvas canvas) {
        for (Ring ring : this.rings) {
            Utils.mutatePaint(this.paint, ring.color, ring.width + 2.0f, Paint.Style.STROKE);
            canvas.drawCircle((float)this.centerX, (float)this.centerY, ring.fixedRadius, this.paint);
        }
    }

    private void drawPolygons(Canvas canvas, int count) {
        for (Ring ring : this.rings) {
            float[] points = ring.vertices;
            float startX = points[0];
            float startY = points[1];
            this.path.reset();
            this.path.moveTo(startX, startY);
            this.path.setLastPoint(startX, startY);
            for (int j = 2; j < count + count; j += 2) {
                this.path.lineTo(points[j], points[j + 1]);
            }
            this.path.close();
            Utils.mutatePaint(this.paint, ring.color, (float)((double)ring.width * StrictMath.cos(Math.PI / (double)count)) + 2.0f, Paint.Style.STROKE);
            canvas.drawPath(this.path, this.paint);
        }
    }

    private void drawValues(Canvas canvas, int count) {
        if (count == 0) {
            return;
        }
        Float[] values = new Float[count];
        values = this.axis.values().toArray(values);
        float[] first = Utils.createPoint(values[0].floatValue() * this.ratio, -1.5707963267948966, this.centerX, this.centerY);
        float firstX = first[0];
        float firstY = first[1];
        this.path.reset();
        this.path.setLastPoint(firstX, firstY);
        if (count == 1) {
            this.path.moveTo((float)this.centerX, (float)this.centerY);
            this.path.lineTo(firstX, firstY);
        } else {
            this.path.moveTo(firstX, firstY);
            for (int i = 1; i < count; ++i) {
                float[] point = Utils.createPoint(values[i].floatValue() * this.ratio, Math.PI * 2 / (double)count * (double)i - 1.5707963267948966, this.centerX, this.centerY);
                this.path.lineTo(point[0], point[1]);
            }
        }
        this.path.close();
        Utils.mutatePaint(this.paint, this.chartColor, this.chartWidth, this.chartStyle);
        canvas.drawPath(this.path, this.paint);
    }

    private void onAxisChanged() {
        if (this.autoSize && !this.axis.isEmpty()) {
            this.setAxisMaxInternal(Collections.max(this.axis.values()).floatValue());
        } else {
            this.buildVertices();
            this.invalidate();
        }
    }

    private void setAxisMaxInternal(float axisMax) {
        this.axisMax = axisMax;
        this.calcRatio();
        this.calcAxisTickInternal();
        this.buildRings();
        this.invalidate();
    }

    private static class Ring {
        final float width;
        final float radius;
        final float fixedRadius;
        final int color;
        float[] vertices;

        Ring(float radius, float width, int color) {
            this.radius = radius;
            this.width = width;
            this.color = color;
            this.fixedRadius = radius - width / 2.0f;
        }

        public String toString() {
            return "Ring{radius=" + this.radius + ", width=" + this.width + ", fixedRadius=" + this.fixedRadius + '}';
        }
    }
}

