/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android.classpath;

import com.dynatrace.tools.android.Version;
import com.dynatrace.tools.android.classpath.IllegalClassPathException;
import java.lang.reflect.Method;

public class ClassPathAnalyzer {
    private final ClassLoader classLoader;

    public ClassPathAnalyzer(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    private boolean containsClasses(String ... names) {
        try {
            for (String name : names) {
                Class.forName(name, false, this.classLoader);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean containsCompuwareAgent() {
        return this.containsClasses("com.compuware.android.app.Activity") || this.containsClasses("com.compuware.apm.uem.mobile.android.CompuwareUEM");
    }

    public boolean containsInstrumentationLibraries() {
        return this.containsClasses("com.dynatrace.android.callback.Callback");
    }

    String determineAgentVersion() {
        return this.determineVersion("com.dynatrace.android.agent.Version");
    }

    String determineReplayAgentVersion() {
        return this.determineVersion("com.dynatrace.android.internal.api.SessionReplayVersion");
    }

    private String determineVersion(String className) {
        try {
            Class<?> clazzVersion = Class.forName(className, true, this.classLoader);
            Method method = clazzVersion.getDeclaredMethod("getFullVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void verifyClassPath(boolean isSessionReplay) {
        if (this.containsCompuwareAgent()) {
            throw new IllegalClassPathException("Invalid agent version detected");
        }
        this.verifyArtifactVersion(this.determineAgentVersion(), "OneAgent SDK");
        if (!this.containsInstrumentationLibraries()) {
            throw new IllegalClassPathException("Instrumentation libraries are missing");
        }
        if (isSessionReplay) {
            this.verifyArtifactVersion(this.determineReplayAgentVersion(), "SessionReplay SDK");
        }
    }

    private void verifyArtifactVersion(String agentVersion, String artifactName) {
        if (agentVersion == null) {
            throw new IllegalClassPathException(artifactName + " missing");
        }
        if (!Version.getFullVersion().equals(agentVersion)) {
            throw new IllegalClassPathException(artifactName + " version " + agentVersion + " does not match Dynatrace Android Gradle plugin version " + Version.getFullVersion());
        }
    }
}

