/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.instrumentation.filter;

import com.dynatrace.android.instrumentation.filter.MethodLevelFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CustomMethodExclusionFilter
implements MethodLevelFilter {
    private Pattern classPattern;
    private Pattern methodPattern;
    private Pattern descPattern;

    public CustomMethodExclusionFilter(String classRegex, String methodRegex, String descRegex) {
        this.classPattern = Pattern.compile(classRegex);
        this.methodPattern = Pattern.compile(methodRegex);
        this.descPattern = Pattern.compile(descRegex);
    }

    @Override
    public boolean filter(String className, String methodName, String methodDescription) {
        Matcher classMatcher = this.classPattern.matcher(className);
        Matcher methodMatcher = this.methodPattern.matcher(methodName);
        Matcher descMatcher = this.descPattern.matcher(methodDescription);
        return classMatcher.find() && methodMatcher.find() && descMatcher.find();
    }
}

