/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.tools.android;

import com.dynatrace.tools.android.ApplicationFlavor;
import com.dynatrace.tools.android.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;

class DynatraceConfig {
    private final NamedDomainObjectCollection<ApplicationFlavor> productFlavors;
    private final ApplicationFlavor defaultConfig;
    private final Project project;
    private File apkitDir = null;

    public DynatraceConfig(Project project) {
        this.project = project;
        this.defaultConfig = new ApplicationFlavor("defaults");
        this.productFlavors = project.container(ApplicationFlavor.class, s -> {
            ApplicationFlavor flavor = new ApplicationFlavor(s);
            flavor.cluster(this.defaultConfig.getCluster());
            flavor.applicationId(this.defaultConfig.getApplicationId());
            flavor.environmentId(this.defaultConfig.getEnvironmentId());
            flavor.startupPath(this.defaultConfig.getStartupPath());
            flavor.agentProperties(this.defaultConfig.getAgentProperties());
            flavor.beaconURL(this.defaultConfig.getBeaconURL());
            return flavor;
        });
    }

    public NamedDomainObjectCollection<ApplicationFlavor> getProductFlavors() {
        return this.productFlavors;
    }

    public ApplicationFlavor getDefaultConfig() {
        return this.defaultConfig;
    }

    public void defaultConfig(Action<ApplicationFlavor> action) {
        action.execute((Object)this.defaultConfig);
    }

    public void productFlavors(Action<NamedDomainObjectCollection<ApplicationFlavor>> action) {
        action.execute(this.productFlavors);
    }

    public synchronized File apkitDir() {
        String agentName = "dynatrace-mobile-agent-android-" + Version.getVersion();
        File tempDir = this.project.getTasks().getByName("prepareApkit").getTemporaryDir();
        if (this.apkitDir == null) {
            this.apkitDir = new File(tempDir, agentName);
        }
        if (!this.apkitDir.exists()) {
            String zipFileName = agentName + ".zip";
            File agentZip = new File(tempDir, zipFileName);
            if (agentZip.exists()) {
                agentZip.delete();
            }
            try (InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(zipFileName);){
                if (input == null) {
                    throw new FileNotFoundException("Could not find file '" + zipFileName + "'");
                }
                Files.copy(input, agentZip.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.project.copy(copy -> {
                copy.from(new Object[]{this.project.zipTree((Object)agentZip)});
                copy.into((Object)this.apkitDir);
            });
        }
        return this.apkitDir;
    }

    public String agent() {
        return "com.dynatrace.agent:agent-android:" + Version.getVersion() + "@aar";
    }

    ApplicationFlavor findProductFlavor(String flavorName) {
        ApplicationFlavor flavor = null;
        if (flavorName != null && flavorName.length() > 0) {
            flavor = (ApplicationFlavor)this.productFlavors.findByName(flavorName.toLowerCase());
        }
        if (flavor == null) {
            flavor = this.defaultConfig;
        }
        return flavor;
    }
}

