/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.DimensionList;
import com.dynatrace.metric.util.Metric;

public class MetricBuilderFactory {
    private final DimensionList dynatraceMetadataDimensions;
    private final DimensionList defaultDimensions;
    private final String prefix;

    private MetricBuilderFactory(DimensionList defaultDimensions, DimensionList dynatraceMetadataDimensions, String prefix) {
        this.dynatraceMetadataDimensions = dynatraceMetadataDimensions;
        this.defaultDimensions = defaultDimensions;
        this.prefix = prefix;
    }

    public static MetricBuilderFactoryBuilder builder() {
        return new MetricBuilderFactoryBuilder();
    }

    public Metric.Builder newMetricBuilder(String metricKey) {
        return Metric.builder(metricKey).setDefaultDimensions(this.defaultDimensions).setDynatraceMetadataDimensions(this.dynatraceMetadataDimensions).setPrefix(this.prefix);
    }

    public static class MetricBuilderFactoryBuilder {
        private DimensionList defaultDimensions;
        private boolean enrichWithDynatraceMetadata;
        private String prefix;

        private MetricBuilderFactoryBuilder() {
        }

        public MetricBuilderFactoryBuilder withDefaultDimensions(DimensionList defaultDimensions) {
            this.defaultDimensions = defaultDimensions;
            return this;
        }

        @Deprecated
        public MetricBuilderFactoryBuilder withOneAgentMetadata() {
            return this.withDynatraceMetadata();
        }

        public MetricBuilderFactoryBuilder withDynatraceMetadata() {
            this.enrichWithDynatraceMetadata = true;
            return this;
        }

        public MetricBuilderFactoryBuilder withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public MetricBuilderFactory build() {
            DimensionList localDynatraceMetadataDimensions = null;
            if (this.enrichWithDynatraceMetadata) {
                localDynatraceMetadataDimensions = DimensionList.fromDynatraceMetadata();
            }
            return new MetricBuilderFactory(this.defaultDimensions, localDynatraceMetadataDimensions, this.prefix);
        }
    }
}

