/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class DynatraceMetadataEnricher {
    private static final Logger logger = Logger.getLogger(DynatraceMetadataEnricher.class.getName());
    private static final String INDIRECTION_FILE_NAME = "dt_metadata_e617c525669e072eebe3d0f08212e8f2.properties";
    private static final String ALTERNATIVE_METADATA_FILENAME = "/var/lib/dynatrace/enrichment/dt_metadata.properties";

    DynatraceMetadataEnricher() {
    }

    static List<Dimension> getDynatraceMetadata() {
        return DynatraceMetadataEnricher.parseDynatraceMetadata(DynatraceMetadataEnricher.getMetadataFileContentWithRedirection(INDIRECTION_FILE_NAME, ALTERNATIVE_METADATA_FILENAME));
    }

    static List<Dimension> parseDynatraceMetadata(Collection<String> lines) {
        ArrayList<Dimension> entries = new ArrayList<Dimension>();
        for (String line : lines) {
            logger.fine(String.format("parsing Dynatrace metadata: %s", line));
            String[] split = line.split("=", 2);
            if (split.length != 2) {
                logger.warning(String.format("could not parse metadata line ('%s')", line));
                continue;
            }
            String key = split[0];
            String value = split[1];
            if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
                logger.warning(String.format("could not parse metadata line ('%s')", line));
                continue;
            }
            entries.add(Dimension.create(key, value));
        }
        return entries;
    }

    static String getMetadataFileName(Reader fileContents) throws IOException {
        if (fileContents == null) {
            throw new IOException("passed Reader cannot be null.");
        }
        String metadataFileName = null;
        try (BufferedReader reader = new BufferedReader(fileContents);){
            String line = reader.readLine();
            if (line != null && !line.isEmpty()) {
                metadataFileName = line;
            }
        }
        return metadataFileName;
    }

    static List<String> getDynatraceMetadataFileContents(Reader fileContents) throws IOException {
        if (fileContents == null) {
            throw new IOException("passed Reader cannot be null.");
        }
        try (BufferedReader reader = new BufferedReader(fileContents);){
            List<String> list = reader.lines().map(String::trim).collect(Collectors.toList());
            return list;
        }
    }

    static boolean fileExistsAndIsReadable(String filePath) {
        try {
            File file = new File(filePath);
            if (file.exists() && Files.isReadable(file.toPath())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static List<String> getMetadataFileContentWithRedirection(String indirectionFileName, String alternativeMetadataFilename) {
        String metadataFileName = null;
        try (FileReader indirectionFileReader = new FileReader(indirectionFileName);){
            metadataFileName = DynatraceMetadataEnricher.getMetadataFileName(indirectionFileReader);
        }
        catch (FileNotFoundException e) {
            logger.info("Indirection file not found. This is normal if OneAgent is not installed.");
        }
        catch (Exception e) {
            logger.info(String.format("Error while trying to read contents of OneAgent indirection file: %s", e));
        }
        if (metadataFileName == null || metadataFileName.isEmpty()) {
            if (DynatraceMetadataEnricher.fileExistsAndIsReadable(alternativeMetadataFilename)) {
                logger.info(String.format("Alternative metadata file exists, attempting to read from %s.", alternativeMetadataFilename));
                metadataFileName = alternativeMetadataFilename;
            } else {
                return Collections.emptyList();
            }
        }
        List<String> properties = Collections.emptyList();
        try (FileReader metadataFileReader = new FileReader(metadataFileName);){
            properties = DynatraceMetadataEnricher.getDynatraceMetadataFileContents(metadataFileReader);
        }
        catch (FileNotFoundException e) {
            logger.warning("Failed to read properties file: File not found");
        }
        catch (Exception e) {
            logger.info(String.format("Error while trying to read contents of Dynatrace metadata file: %s", e));
        }
        return properties;
    }
}

