/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.activitytracking;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.view.WindowMetrics;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsCollector;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsUtility;

public class ActivityScreenMetricsCollector
implements ScreenMetricsCollector {
    static DisplayAccessor accessor = activity -> {
        if (Build.VERSION.SDK_INT >= 30) {
            return activity.getDisplay();
        }
        return null;
    };

    @Deprecated(since="Android API level 30")
    public static ScreenMetrics calculateMetrics(Display display, int orientation) {
        ScreenMetrics.Builder metricsBuilder = new ScreenMetrics.Builder();
        DisplayMetrics metrics = ScreenMetricsUtility.getDisplayMetricsFromDisplay(display);
        metricsBuilder.withScreenDensityFactor(metrics.density);
        metricsBuilder.withScreenDensityDpi(metrics.densityDpi);
        Point displayMeasures = ScreenMetricsUtility.getDimensionsFromDisplay(display);
        if (ActivityScreenMetricsCollector.isLandscapeNaturalOrientation(display.getRotation(), orientation)) {
            metricsBuilder.withScreenWidth(Math.max(displayMeasures.x, displayMeasures.y));
            metricsBuilder.withScreenHeight(Math.min(displayMeasures.x, displayMeasures.y));
        } else {
            metricsBuilder.withScreenWidth(Math.min(displayMeasures.x, displayMeasures.y));
            metricsBuilder.withScreenHeight(Math.max(displayMeasures.x, displayMeasures.y));
        }
        return metricsBuilder.build();
    }

    private static boolean isLandscapeNaturalOrientation(int rotation, int orientation) {
        if (orientation == 2) {
            return rotation == 0 || rotation == 2;
        }
        if (orientation == 1) {
            return rotation == 1 || rotation == 3;
        }
        return false;
    }

    @Override
    public ScreenMetrics collectMetrics(Activity activity) {
        WindowManager windowManager = (WindowManager)activity.getSystemService("window");
        Configuration config = activity.getResources().getConfiguration();
        int orientation = config.orientation;
        if (Build.VERSION.SDK_INT <= 29) {
            Display display = windowManager.getDefaultDisplay();
            return ActivityScreenMetricsCollector.calculateMetrics(display, orientation);
        }
        ScreenMetrics.Builder metricsBuilder = new ScreenMetrics.Builder();
        Display activeDisplay = accessor.getDisplay(activity);
        int rotation = activeDisplay != null ? activeDisplay.getRotation() : 0;
        WindowMetrics windowMetrics = windowManager.getMaximumWindowMetrics();
        Rect rect = windowMetrics.getBounds();
        if (ActivityScreenMetricsCollector.isLandscapeNaturalOrientation(rotation, orientation)) {
            metricsBuilder.withScreenWidth(Math.max(rect.width(), rect.height()));
            metricsBuilder.withScreenHeight(Math.min(rect.width(), rect.height()));
        } else {
            metricsBuilder.withScreenWidth(Math.min(rect.width(), rect.height()));
            metricsBuilder.withScreenHeight(Math.max(rect.width(), rect.height()));
        }
        int densityDpi = config.densityDpi;
        metricsBuilder.withScreenDensityFactor((float)densityDpi / 160.0f);
        metricsBuilder.withScreenDensityDpi(densityDpi);
        return metricsBuilder.build();
    }

    @FunctionalInterface
    static interface DisplayAccessor {
        public Display getDisplay(Activity var1);
    }
}

