/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.action;

import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.lifecycle.action.LifecycleAction;
import com.dynatrace.android.lifecycle.event.LifecycleEvent;
import com.dynatrace.android.useraction.LifecyclePlaceholderSegment;
import com.dynatrace.android.useraction.UserAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class LifecycleActionImpl<T extends Enum<T>>
implements LifecycleAction<T> {
    private final String name;
    private final MeasurementPoint startPoint;
    private final UserAction parentAction;
    @Deprecated
    private final LifecyclePlaceholderSegment placeholderSegment;
    private final AtomicBoolean isFinalized;
    private final Map<T, MeasurementPoint> lifecycleEvents = new HashMap<T, MeasurementPoint>();
    private MeasurementPoint endPoint;

    public LifecycleActionImpl(ImmutableData data) {
        this.isFinalized = new AtomicBoolean(false);
        this.name = data.getName();
        this.startPoint = data.getStartPoint();
        this.parentAction = data.getParentAction();
        this.placeholderSegment = data.getPlaceholderSegment();
    }

    @Override
    public void addEvent(LifecycleEvent<T> event) {
        this.lifecycleEvents.put(event.getEventType(), new MeasurementPoint(event.getTimestamp(), event.getSequenceNumber()));
    }

    @Override
    public Map<T, MeasurementPoint> getLifecycleEvents() {
        return this.lifecycleEvents;
    }

    @Override
    public AtomicBoolean isFinalized() {
        return this.isFinalized;
    }

    @Override
    public LifecyclePlaceholderSegment getPlaceholderSegment() {
        return this.placeholderSegment;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MeasurementPoint getStartPoint() {
        return this.startPoint;
    }

    @Override
    public MeasurementPoint getEndPoint() {
        return this.endPoint;
    }

    @Override
    public void setEndPoint(MeasurementPoint endPoint) {
        this.endPoint = endPoint;
    }

    @Override
    public UserAction getParentAction() {
        return this.parentAction;
    }

    public String toString() {
        return "LifecycleActionImpl{name='" + this.name + '\'' + ", startPoint=" + this.startPoint + ", endPoint=" + this.endPoint + ", parentAction=" + this.parentAction + ", lifecycleEvents=" + this.lifecycleEvents + '}';
    }

    public static class ImmutableData {
        private String name;
        private MeasurementPoint startPoint;
        private UserAction parentAction;
        @Deprecated
        private LifecyclePlaceholderSegment placeholderSegment;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public MeasurementPoint getStartPoint() {
            return this.startPoint;
        }

        public void setStartPoint(MeasurementPoint startPoint) {
            this.startPoint = startPoint;
        }

        public UserAction getParentAction() {
            return this.parentAction;
        }

        public void setParentAction(UserAction parentAction) {
            this.parentAction = parentAction;
        }

        public LifecyclePlaceholderSegment getPlaceholderSegment() {
            return this.placeholderSegment;
        }

        @Deprecated
        public void setPlaceholderSegment(LifecyclePlaceholderSegment placeholderSegment) {
            this.placeholderSegment = placeholderSegment;
        }
    }
}

