/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.mixed;

import com.dynatrace.android.agent.util.Utility;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class BaseWebRequestEventGenerator {
    protected String url;
    protected String networkProtocolName;
    protected int statusCode = -1;
    protected String reasonPhrase;
    private final String name;

    BaseWebRequestEventGenerator(String name) {
        this.name = name;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setNetworkProtocolName(String networkProtocolName) {
        this.networkProtocolName = networkProtocolName;
    }

    public void setReasonPhrase(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public JSONObject generateRumRequestEvent() {
        if (this.url == null || this.networkProtocolName == null || this.networkProtocolName.isEmpty()) {
            Utility.devLog((String)"dtxEventGeneration", (String)(this.name + " generateRumRequestEvent failed for, url: " + this.url + ", networkProtocolName: " + this.networkProtocolName));
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("characteristics.has_request", true);
            jsonObject.put("url.full", (Object)this.url);
            jsonObject = this.populateJson(jsonObject);
            return jsonObject;
        }
        catch (JSONException e) {
            Utility.devLog((String)"dtxEventGeneration", (String)(this.name + " generateRumRequestEvent failed with exception"));
            return null;
        }
    }

    protected abstract JSONObject populateJson(JSONObject var1) throws JSONException;
}

