/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.location.Location;
import android.webkit.WebView;
import com.dynatrace.agent.api.HttpRequestEventBuilder;
import com.dynatrace.agent.events.EventFieldsProvider;
import com.dynatrace.agent.events.EventModifier;
import com.dynatrace.agent.events.error.ErrorEvent;
import com.dynatrace.agent.events.error.ExceptionEventContent;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.DTXAction;
import com.dynatrace.android.agent.DTXActionImpl;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.JavascriptAgentInterface;
import com.dynatrace.android.agent.NullAction;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.UserActionModifier;
import com.dynatrace.android.agent.WebReqTag;
import com.dynatrace.android.agent.WebRequestTiming;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.DataCollectionLevel;
import com.dynatrace.android.agent.conf.PrivacyRules;
import com.dynatrace.android.agent.conf.UserPrivacyOptions;
import com.dynatrace.android.agent.crash.CrashCatcher;
import com.dynatrace.android.agent.crash.JavaStacktraceProcessor;
import com.dynatrace.android.agent.crash.PlatformType;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.mixed.AgentServiceLocatorImpl;
import com.dynatrace.android.agent.mixed.SecondGenServiceLocatorImpl;
import com.dynatrace.android.agent.mixed.SessionInformationGenerator;
import com.dynatrace.android.agent.mixed.TimeProviderFactory;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.internal.api.ProcessAnalyzer;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONObject;

public class Dynatrace {
    static final String ILLEGAL_STATE_ERROR = AdkSettings.getADKName() + " not running";
    private static final String JS_INTERFACE_NAME = "MobileAgent";
    private static final String LOGTAG = Global.LOG_PREFIX + "Dynatrace";
    private static final String HEADER = "x-dynatrace";
    private static final Object mOperationPending = new Object();
    private static AtomicBoolean isAlreadyStarted = new AtomicBoolean(false);

    public static void startup(Application application, Configuration configuration) {
        Dynatrace.startup(application, null, configuration);
    }

    public static void startup(Activity activity, Configuration configuration) {
        Dynatrace.startup((Application)activity.getApplicationContext(), activity, configuration);
    }

    @Deprecated
    public static void startup(Context context, Configuration configuration) {
        if (context instanceof Application) {
            Dynatrace.startup((Application)context, configuration);
        } else if (context instanceof Activity) {
            Dynatrace.startup((Activity)context, configuration);
        } else {
            Dynatrace.startup((Application)context.getApplicationContext(), configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startup(Application application, Activity activeActivity, Configuration configuration) {
        if (application == null || configuration == null) {
            return;
        }
        if (Utility.isIsolatedProcess()) {
            if (configuration.debugLogLevel) {
                Utility.zlogD((String)LOGTAG, (String)"Isolated service detected. Monitoring deactivated for this process");
            }
            return;
        }
        if (new ProcessAnalyzer().isInternalProcess()) {
            return;
        }
        Object object = mOperationPending;
        synchronized (object) {
            block10: {
                if (isAlreadyStarted.get()) {
                    return;
                }
                try {
                    Core.startup(application, activeActivity, configuration, new AgentServiceLocatorImpl(configuration.toOneAgentConfiguration(), new TimeProviderFactory().createTimelineProvider(), application, configuration.httpFactory, new SecondGenServiceLocatorImpl((Context)application)));
                    isAlreadyStarted.set(true);
                }
                catch (Exception e) {
                    if (!Global.DEBUG) break block10;
                    Utility.zlogD((String)LOGTAG, (String)"unable to start agent", (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    public static void shutdown() {
        Dynatrace.shutdown(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void shutdown(final long lStopTimeLimitSec) {
        Object object = mOperationPending;
        synchronized (object) {
            if (!isAlreadyStarted.compareAndSet(true, false)) {
                if (Global.DEBUG) {
                    Utility.zlogD((String)LOGTAG, (String)"Not initialized - skip shutdown");
                }
                return;
            }
            Core.forceCloseActiveActions("agent shutdown");
            CrashCatcher.uninstallUncaughtExceptionHandler();
            CrashCatcher.unregisterUncaughtExceptionListener(Core.getCrashListener());
            Core.communicationManager.stopTimerLoop();
        }
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = mOperationPending;
                synchronized (object) {
                    Core.shutdown(lStopTimeLimitSec);
                }
            }
        };
        t.start();
    }

    protected static void pause() {
        if (!Global.isAlive.get()) {
            return;
        }
        Core.flushEvents();
    }

    protected static void resume() {
        if (!Global.isAlive.get()) {
            return;
        }
        Core.communicationManager.startTimerLoop(false);
    }

    public static boolean getCaptureStatus() {
        if (!Global.isAlive.get()) {
            return false;
        }
        return Core.getCaptureState();
    }

    public static void setGpsLocation(Location location) {
        if (!Global.isAlive.get()) {
            return;
        }
        Core.setGpsLocation(location);
    }

    public static String getRequestTagHeader() {
        return HEADER;
    }

    public static String getRequestTag() {
        if (!Global.isAlive.get()) {
            return "";
        }
        return WebReqTag.tagToString(Core.getRequestTag());
    }

    @Deprecated
    public static void tagRequest(HttpURLConnection conn) {
        block3: {
            if (conn == null || !Dynatrace.getCaptureStatus()) {
                return;
            }
            try {
                conn.setRequestProperty(Dynatrace.getRequestTagHeader(), WebReqTag.tagToString(Core.getRequestTag()));
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block3;
                Utility.zlogE((String)LOGTAG, (String)e.toString());
            }
        }
    }

    public static DTXAction enterAction(String actionName) {
        if (!Global.isAlive.get()) {
            return NullAction.INSTANCE;
        }
        return DTXActionImpl.createAction(actionName, null);
    }

    public static DTXAction enterAction(String actionName, DTXAction parentAction) {
        if (!Global.isAlive.get() || parentAction instanceof NullAction) {
            return NullAction.INSTANCE;
        }
        return DTXActionImpl.createAction(actionName, parentAction);
    }

    public static void endVisit() {
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Core.endVisit();
    }

    public static void reportError(String errorName, int errorCode) {
        Utility.devLog((String)"dtxEventGeneration", (String)("reportError, errorName: " + errorName + ", errorCode: " + errorCode));
        if (errorName == null) {
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Session session = Session.determineActiveSession(false);
        Core.GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
            if (session.getPrivacyRules().shouldCollectEvent(EventType.EVENT_API)) {
                JSONObject jsonObject = ErrorEvent.generateErrorEvent((String)errorName, (int)errorCode, (boolean)true);
                if (jsonObject != null) {
                    eventDispatcher.dispatchEvent(jsonObject, TimeLineProvider.getSystemTime(), 0L, SessionInformationGenerator.generate(session), true, null);
                }
            } else {
                Utility.devLog((String)"dtxEventGeneration", (String)("reportError eventType shouldn't be collected, because of data collection level: " + (Object)((Object)EventType.EVENT_API)));
            }
        });
        Dynatrace.reportError(errorName, 9, session, String.valueOf(errorCode));
    }

    static void internalReportError(String errorName, int errorCode) {
        if (errorName == null) {
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Session session = Session.determineActiveSession(false);
        Dynatrace.reportError(errorName, 9, session, String.valueOf(errorCode));
    }

    public static void reportError(String errorName, Throwable throwable) {
        Utility.devLog((String)"dtxEventGeneration", (String)("reportError, errorName: " + errorName));
        if (errorName == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"event is rejected, name can't be null");
            return;
        }
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Session session = Session.determineActiveSession(false);
        if (throwable != null) {
            Core.GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
                if (session.getPrivacyRules().shouldCollectEvent(EventType.EVENT_API)) {
                    JSONObject jsonObject = ErrorEvent.errorExceptionEvent((Throwable)throwable, (String)errorName, (boolean)true);
                    if (jsonObject != null) {
                        eventDispatcher.dispatchEvent(jsonObject, TimeLineProvider.getSystemTime(), 0L, SessionInformationGenerator.generate(session), true, null);
                    }
                } else {
                    Utility.devLog((String)"dtxEventGeneration", (String)("reportError eventType shouldn't be collected, because of data collection level: " + (Object)((Object)EventType.EVENT_API)));
                }
            });
        } else {
            Utility.devLog((String)"dtxEventGeneration", (String)"Grail event is rejected, throwable can't be null");
        }
        int maxLines = AdkSettings.getInstance().getConfiguration().mode == AgentMode.APP_MON ? 10 : Integer.MAX_VALUE;
        StacktraceData stacktraceData = throwable == null ? new StacktraceData(null, null, null, PlatformType.JAVA) : new JavaStacktraceProcessor(throwable, maxLines).process();
        Dynatrace.reportError(errorName, 10, session, stacktraceData.getName(), stacktraceData.getReason(), stacktraceData.getStacktrace(), stacktraceData.getType().getProtocolValue());
    }

    public static void sendExceptionEvent(Throwable throwable, EventFieldsProvider fieldsProvider) {
        Utility.devLog((String)"dtxEventGeneration", (String)("sendExceptionEvent is executed with fieldsProvider: " + (fieldsProvider != null ? fieldsProvider.getClass().getName() : "")));
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        if (throwable == null) {
            Utility.devLog((String)"dtxEventGeneration", (String)"event is rejected, throwable can't be null");
            return;
        }
        Session session = Session.determineActiveSession(false);
        Core.GUARDED_EVENT_DISPATCHER.executeWithVerification(session, eventDispatcher -> {
            if (session.getPrivacyRules().shouldCollectEvent(EventType.EVENT_API)) {
                ExceptionEventContent eventContent = ErrorEvent.exceptionEvent((Throwable)throwable, (EventFieldsProvider)fieldsProvider);
                if (eventContent != null) {
                    eventDispatcher.dispatchEventWithRestrictions(eventContent.getCustomerJson(), eventContent.getAgentJson(), SessionInformationGenerator.generate(session), null);
                }
            } else {
                Utility.devLog((String)"dtxEventGeneration", (String)("sendExceptionEvent eventType shouldn't be collected, because of data collection level: " + (Object)((Object)EventType.EVENT_API)));
            }
        });
    }

    public static void sendHttpRequestEvent(HttpRequestEventBuilder httpRequestEventBuilder) {
        if (Global.isAlive.get() && Core.oneAgentFacade != null) {
            Core.oneAgentFacade.sendHttpRequestEvent(httpRequestEventBuilder);
        } else {
            Utility.devLog((String)"dtxEventGeneration", (String)("sendHttpRequestEvent can't be executed, isAlive: " + Global.isAlive.get() + " Grail is enabled: " + (Core.oneAgentFacade != null)));
        }
    }

    public static void startView(String name) {
        if (Global.isAlive.get() && Core.oneAgentFacade != null) {
            Core.oneAgentFacade.startView(name);
        } else {
            Utility.devLog((String)"dtxViewContext", (String)("start view can't be executed, isAlive: " + Global.isAlive.get() + " Grail is enabled: " + (Core.oneAgentFacade != null)));
        }
    }

    public static void stopView() {
        if (Global.isAlive.get() && Core.oneAgentFacade != null) {
            Core.oneAgentFacade.stopView();
        } else {
            Utility.devLog((String)"dtxViewContext", (String)("stop view can't be executed, Grail is enabled: " + (Core.oneAgentFacade != null)));
        }
    }

    static void reportError(PlatformType type, String errorName, String errorValue, String reason, String stacktrace) {
        if (type == null || errorName == null) {
            return;
        }
        Session session = Session.determineActiveSession(false);
        Dynatrace.reportError(errorName, 20, session, Utility.truncateString((String)errorValue, (int)250), Utility.truncateString((String)reason, (int)1000), Utility.truncateString((String)stacktrace, (int)128000), type.getProtocolValue());
    }

    static void reportCrash(PlatformType type, String crashName, String reason, String stacktrace) {
        if (type == null || crashName == null) {
            return;
        }
        Dynatrace.reportCrash(crashName, 21, Utility.truncateString((String)reason, (int)1000), Utility.truncateString((String)stacktrace, (int)128000), type.getProtocolValue());
    }

    static void createNewSession() {
        if (!Global.isAlive.get()) {
            return;
        }
        Core.startNewSession(true, Session.currentSession().getPrivacyRules());
    }

    private static void reportCrash(String errorName, int eventType, String ... values) {
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Session session = Session.determineActiveSession(false);
        if (!session.getPrivacyRules().shouldCollectEvent(EventType.CRASH)) {
            return;
        }
        int serverId = AdkSettings.getInstance().serverId;
        Core.addEvent(errorName, eventType, 0L, null, session, serverId, values);
    }

    private static void reportError(String errorName, int eventType, Session session, String ... values) {
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        int serverId = AdkSettings.getInstance().serverId;
        Core.addEvent(errorName, eventType, 0L, null, session, serverId, values);
    }

    public static void flushEvents() {
        if (!Global.isAlive.get()) {
            return;
        }
        Core.flushEvents();
    }

    public static void setBeaconHeaders(Map<String, String> headers) {
        if (headers == null || headers.isEmpty()) {
            AdkSettings.customBeaconHeaders = null;
        } else {
            HashMap<String, String> copy = new HashMap<String, String>(headers);
            AdkSettings.customBeaconHeaders = copy;
            if (Global.isAlive.get()) {
                Core.communicationManager.scheduleNewBeaconRequest();
            }
        }
    }

    public static WebRequestTiming getWebRequestTiming(String tag) {
        return new WebRequestTiming(tag);
    }

    public static WebRequestTiming getWebRequestTiming(HttpURLConnection connection) {
        return new WebRequestTiming(connection);
    }

    static WebRequestTiming internalGetWebRequestTiming(String tag) {
        return new WebRequestTiming(tag, false);
    }

    public static void identifyUser(String userId) {
        if (!Dynatrace.getCaptureStatus()) {
            return;
        }
        Session session = Session.determineActiveSession(false);
        if (session.getPrivacyRules().shouldCollectEvent(EventType.IDENTIFY_USER)) {
            session.setUserTag(userId == null || userId.isEmpty() ? null : userId);
            Core.reportUserTag(session);
        }
    }

    @Deprecated
    public static void identifyUser(String userId, DTXAction parentAction) {
        Dynatrace.identifyUser(userId);
    }

    public static UserPrivacyOptions getUserPrivacyOptions() {
        if (!Global.isAlive.get()) {
            return PrivacyRules.PRIVACY_MODE_DEACTIVATED.getPrivacySettings();
        }
        return Session.currentSession().getPrivacyRules().getPrivacySettings();
    }

    public static void applyUserPrivacyOptions(UserPrivacyOptions userPrivacyOptions) {
        if (!Global.isAlive.get()) {
            return;
        }
        if (!AdkSettings.getInstance().getConfiguration().userOptIn) {
            return;
        }
        UserPrivacyOptions userPrivacyOptionsChecked = userPrivacyOptions;
        if (!userPrivacyOptions.isCrashReportingOptedIn() && userPrivacyOptions.isCrashReplayOptedIn()) {
            userPrivacyOptionsChecked = userPrivacyOptions.newBuilder().withCrashReplayOptedIn(false).build();
            if (Global.DEBUG) {
                Utility.zlogE((String)LOGTAG, (String)"CrashReplayOptedIn cannot be true when CrashReportOptIn is false");
            }
        }
        if (userPrivacyOptionsChecked.equals(Dynatrace.getUserPrivacyOptions())) {
            return;
        }
        AdkSettings.getInstance().preferencesManager.storePrivacySettings(userPrivacyOptionsChecked);
        Core.startNewSession(true, new PrivacyRules(userPrivacyOptionsChecked));
    }

    @Deprecated
    public static boolean isCrashReportingOptedIn() {
        if (!Global.isAlive.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        return Dynatrace.getUserPrivacyOptions().isCrashReportingOptedIn();
    }

    @Deprecated
    public static void setCrashReportingOptedIn(boolean confirmed) {
        if (!Global.isAlive.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        Dynatrace.applyUserPrivacyOptions(Dynatrace.getUserPrivacyOptions().newBuilder().withCrashReportingOptedIn(confirmed).build());
    }

    @Deprecated
    public static DataCollectionLevel getDataCollectionLevel() {
        if (!Global.isAlive.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        return Dynatrace.getUserPrivacyOptions().getDataCollectionLevel();
    }

    @Deprecated
    public static void setDataCollectionLevel(DataCollectionLevel dataCollectionLevel) {
        if (!Global.isAlive.get()) {
            throw new IllegalStateException(ILLEGAL_STATE_ERROR);
        }
        Dynatrace.applyUserPrivacyOptions(Dynatrace.getUserPrivacyOptions().newBuilder().withDataCollectionLevel(dataCollectionLevel).build());
    }

    static DTXAction integrateNewAction(String actionName) {
        if (!Global.isAlive.get()) {
            return NullAction.INSTANCE;
        }
        DTXAutoAction gaua = DTXAutoAction.getAutoAction();
        if (gaua != null) {
            return DTXActionImpl.createAction(actionName, gaua);
        }
        Session session = Session.determineActiveSession(false);
        int serverId = AdkSettings.getInstance().serverId;
        DTXAutoAction globalAction = DTXAutoAction.createAutoAction(actionName, session, serverId);
        globalAction.startTimer(1000);
        return globalAction;
    }

    public static void modifyUserAction(UserActionModifier modifier) {
        if (!Global.isAlive.get()) {
            return;
        }
        Core.modifyUserAction(modifier);
    }

    public static boolean addEventModifier(EventModifier eventModifier) {
        if (eventModifier != null) {
            return Core.GUARDED_EVENT_DISPATCHER.addEventModifier(eventModifier);
        }
        Utility.devLog((String)"dtxEventGeneration", (String)"adding a null EventModifier is not allowed");
        return false;
    }

    public static boolean removeEventModifier(EventModifier eventModifier) {
        return Core.GUARDED_EVENT_DISPATCHER.removeEventModifier(eventModifier);
    }

    public static void instrumentWebView(WebView webView) {
        if (webView != null && AdkSettings.getInstance().hybridApp) {
            webView.getSettings().setJavaScriptEnabled(true);
            webView.addJavascriptInterface((Object)new JavascriptAgentInterface(), JS_INTERFACE_NAME);
        }
    }

    public static void restoreCookies() {
        if (Global.isAlive.get()) {
            if (Global.DEBUG) {
                Utility.zlogD((String)LOGTAG, (String)"restore cookies");
            }
            Core.restoreCookies();
        }
    }

    public static void sendEvent(JSONObject fields, Object[] eventContext) {
        if (Dynatrace.getCaptureStatus()) {
            Utility.devLog((String)"dtxEventGeneration", (String)"send a JSON event to the enrichment pipeline");
            Core.sendEvent(fields, eventContext);
        } else {
            Utility.devLog((String)"dtxEventGeneration", (String)"send event not possible, capturing is disabled");
        }
    }

    public static void sendBizEvent(String type, JSONObject attributes) {
        if (Dynatrace.getCaptureStatus()) {
            Core.sendBizEvent(type, attributes);
        }
    }

    public static void sendSessionPropertyEvent(JSONObject properties) {
        if (Dynatrace.getCaptureStatus()) {
            Core.sendSessionPropertyEvent(properties);
        } else {
            Utility.devLog((String)"dtxEventGeneration", (String)"send session property event not possible, capturing is disabled");
        }
    }
}

