/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import android.content.Context;
import com.dynatrace.android.agent.AgentStateListener;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.PreferencesManager;
import com.dynatrace.android.agent.conf.ServerConfiguration;
import com.dynatrace.android.agent.conf.ServerConfigurationManager;
import com.dynatrace.android.agent.conf.SessionSplitConfiguration;
import com.dynatrace.android.agent.util.Utility;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class AdkSettings {
    public static final String TECHNOLOGY_TYPE = "maandroid";
    public static final String PLATFORM_TYPE_MOBILE = "0";
    public static final int GLOBAL_CHAR_LIMIT = 250;
    public static final int SELF_MONITORING_PAYLOAD_CHAR_LIMIT = 1000;
    static final String ONE_AGENT_PROTOCOL_VERSION = "3";
    private static final String LOGTAG = Global.LOG_PREFIX + "AdkSettings";
    public static String appIdEncoded = "";
    public static String applName = "";
    public static String applIdentifier = "";
    public static volatile Map<String, String> customBeaconHeaders = null;
    private static AdkSettings theInstance = new AdkSettings();
    public AtomicBoolean newVisitorSentPending = new AtomicBoolean(false);
    public AtomicBoolean newVisitorSent = new AtomicBoolean(true);
    public int serverId = 1;
    public PreferencesManager preferencesManager = null;
    boolean hybridApp = false;
    private Context context;
    private Configuration configuration;
    private AgentStateListener agentStateListener;
    private volatile ServerConfiguration serverConfiguration;

    private AdkSettings() {
        this.switchServerConfiguration(new ServerConfiguration.Builder().withServerId(1).build());
    }

    public static AdkSettings getInstance() {
        return theInstance;
    }

    static String getADKName() {
        return "Dynatrace OneAgent (Android)";
    }

    public Context getContext() {
        return this.context;
    }

    public void setup(Configuration configuration, Context ctx) {
        this.configuration = configuration;
        this.hybridApp = configuration.hybridApp;
        if (ctx == null || this.context == ctx.getApplicationContext()) {
            return;
        }
        this.context = ctx;
        applName = Utility.truncateString((String)this.context.getApplicationInfo().loadLabel(this.context.getPackageManager()).toString(), (int)250);
        applIdentifier = Utility.truncateString((String)this.context.getPackageName(), (int)250);
        this.preferencesManager = PreferencesManager.createPreferencesManager(this.context, new ServerConfigurationManager(configuration.appIdEncoded));
        this.newVisitorSent.set(this.preferencesManager.getNewVisitorFlag());
    }

    public void setNewVisitorSent(boolean newValue) {
        this.newVisitorSent.set(newValue);
        this.preferencesManager.setNewVisitorSent(newValue);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public void switchServerConfiguration(ServerConfiguration newServerConfig) {
        if (Global.DEBUG) {
            Utility.zlogD((String)LOGTAG, (String)("switching settings: " + newServerConfig));
        }
        this.serverConfiguration = newServerConfig;
    }

    public SessionSplitConfiguration getSessionSplitConfiguration() {
        return this.serverConfiguration.getSessionSplitConfiguration();
    }

    public AgentStateListener getAgentStateListener() {
        return this.agentStateListener;
    }

    public void setAgentStateListener(AgentStateListener agentStateListener) {
        this.agentStateListener = agentStateListener;
    }
}

