/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.appstart;

import android.app.Application;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.measurement.MeasurementPoint;
import com.dynatrace.android.agent.measurement.MeasurementProvider;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.appstart.ActivityStateListener;
import com.dynatrace.android.lifecycle.appstart.AppStartAction;
import com.dynatrace.android.lifecycle.appstart.AppStartActionObserver;
import com.dynatrace.android.lifecycle.appstart.AppStartAggregator;
import com.dynatrace.android.useraction.AppStartPlaceholderSegment;
import com.dynatrace.android.useraction.DTXAutoActionWrapper;
import java.util.concurrent.atomic.AtomicBoolean;

public class AppStartController {
    private static final String LOG_TAG = Global.LOG_PREFIX + "AppStartController";
    private final MeasurementProvider measurementProvider;
    private final AppStartAggregator appStartAggregator;
    private final AppStartActionObserver appStartActionObserver;
    private final AtomicBoolean isActionFinalized;
    private final ActivityStateListener activityStateListener;
    private final Application application;
    private AppStartAction.Builder appStartActionBuilder;

    public AppStartController(MeasurementProvider measurementProvider, AppStartAggregator appStartAggregator, AppStartActionObserver appStartActionObserver, Application application) {
        this.measurementProvider = measurementProvider;
        this.appStartAggregator = appStartAggregator;
        this.appStartActionObserver = appStartActionObserver;
        this.application = application;
        this.activityStateListener = new ActivityStateListener(this, measurementProvider);
        this.isActionFinalized = new AtomicBoolean(false);
    }

    public void appStart(String applicationName, MeasurementPoint userActionStartPoint, MeasurementPoint appStartPoint) {
        DTXAutoActionWrapper parentAction = this.appStartAggregator.determineUserAction(applicationName, userActionStartPoint);
        parentAction.startTimer(5000);
        AppStartPlaceholderSegment placeholderSegment = new AppStartPlaceholderSegment(applicationName, parentAction, this);
        this.appStartAggregator.aggregatePlaceholder(placeholderSegment);
        this.appStartActionBuilder = new AppStartAction.Builder().withName(applicationName).withStartPoint(appStartPoint).withParentAction(parentAction).withPlaceholderSegment(placeholderSegment);
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityStateListener);
    }

    public void appStartComplete(MeasurementPoint endPoint, String activityName) {
        if (this.isActionFinalized.compareAndSet(false, true)) {
            this.appStartActionBuilder.withEndPoint(endPoint);
            this.appStartActionBuilder.withName(activityName);
            AppStartAction appStartAction = this.appStartActionBuilder.build();
            if (Global.DEBUG) {
                Utility.zlogD((String)LOG_TAG, (String)("AppStart action completed: " + appStartAction));
            }
            this.appStartActionObserver.onAppStartCompleted(appStartAction);
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityStateListener);
        }
    }

    public void appStartStopped() {
        this.appStartComplete(this.measurementProvider.measure(), null);
    }

    public void cancelAppStart() {
        if (this.isActionFinalized.compareAndSet(false, true)) {
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.activityStateListener);
            if (Global.DEBUG) {
                Utility.zlogD((String)LOG_TAG, (String)"AppStart action dropped");
            }
        }
    }

    AppStartAction.Builder getAppStartActionBuilder() {
        return this.appStartActionBuilder;
    }

    boolean isActionFinalized() {
        return this.isActionFinalized.get();
    }

    ActivityStateListener getActivityStateListener() {
        return this.activityStateListener;
    }
}

