/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.activitytracking;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import android.view.WindowMetrics;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsCollector;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsUtility;

public class ActivityScreenMetricsCollector
implements ScreenMetricsCollector {
    @Override
    public ScreenMetrics collectMetrics(Activity activity) {
        ScreenMetrics.Builder metricsBuilder = new ScreenMetrics.Builder();
        WindowManager windowManager = (WindowManager)activity.getSystemService("window");
        if (Build.VERSION.SDK_INT <= 29) {
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics metrics = ScreenMetricsUtility.getDisplayMetricsFromDisplay(display);
            metricsBuilder.withScreenDensityFactor(metrics.density);
            metricsBuilder.withScreenDensityDpi(metrics.densityDpi);
            Point displayMeasures = ScreenMetricsUtility.getDimensionsFromDisplay(display);
            metricsBuilder.withScreenWidth(displayMeasures.x);
            metricsBuilder.withScreenHeight(displayMeasures.y);
        } else {
            WindowMetrics windowMetrics = windowManager.getMaximumWindowMetrics();
            Rect rect = windowMetrics.getBounds();
            metricsBuilder.withScreenWidth(rect.width());
            metricsBuilder.withScreenHeight(rect.height());
            Configuration config = activity.getResources().getConfiguration();
            int densityDpi = config.densityDpi;
            metricsBuilder.withScreenDensityFactor((float)densityDpi / 160.0f);
            metricsBuilder.withScreenDensityDpi(densityDpi);
        }
        return metricsBuilder.build();
    }
}

