/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent;

import com.dynatrace.android.agent.CustomSegment;
import com.dynatrace.android.agent.EventType;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;

public class WebReqSegment
extends CustomSegment {
    protected String respPhrase;
    protected int respCode;
    private long endLcSeqNum;
    private long sendBytes;
    private long receivedBytes;
    private String serverTiming;
    private boolean forwardToGrail;

    public WebReqSegment(long parentTagId, int seqNumber, long startTime, long endTime, int respCode, String respPhrase, String url, long sendBytes, long receivedBytes, Session session, int serverId, String serverTiming, boolean forwardToGrail) {
        super(url, 6, EventType.WEB_REQUEST, parentTagId, seqNumber, startTime, endTime, session, serverId, forwardToGrail);
        this.respCode = respCode;
        this.respPhrase = respPhrase;
        this.endLcSeqNum = Utility.getEventSeqNum();
        this.sendBytes = sendBytes;
        this.receivedBytes = receivedBytes;
        this.serverTiming = serverTiming;
        this.forwardToGrail = forwardToGrail;
    }

    @Override
    public StringBuilder createEventData() {
        StringBuilder sb = new StringBuilder();
        sb.append("et=").append(this.eventType.getProtocolId());
        sb.append("&na=").append(Utility.urlEncode((String)this.getName()));
        sb.append("&it=").append(Thread.currentThread().getId());
        sb.append("&pa=").append(this.getParentTagId());
        sb.append("&s0=").append(this.lcSeqNum);
        sb.append("&t0=").append(this.getStartTime());
        sb.append("&s1=").append(this.endLcSeqNum);
        sb.append("&t1=").append(this.getEndTime() - this.getStartTime());
        if (this.respCode > 0) {
            sb.append("&rc=").append(this.respCode);
        } else if (this.respPhrase != null) {
            sb.append("&rc=").append(Utility.urlEncode((String)this.respPhrase));
        }
        if (this.sendBytes >= 0L && this.receivedBytes >= 0L) {
            sb.append("&bs=").append(this.sendBytes);
            sb.append("&br=").append(this.receivedBytes);
        }
        if (this.serverTiming != null) {
            sb.append("&si=").append(Utility.urlEncode((String)this.serverTiming));
        }
        sb.append("&fw=").append(this.forwardToGrail ? "1" : "0");
        return sb;
    }
}

