/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.window;

import android.view.Window;
import com.dynatrace.android.window.DefaultWindowCallback;
import com.dynatrace.android.window.OnKeyEventListener;
import com.dynatrace.android.window.OnTouchEventListener;
import com.dynatrace.android.window.WindowCallbackWrapper;
import com.dynatrace.android.window.WindowEventSegmentation;
import com.dynatrace.android.window.WindowListenerFactory;
import java.util.ArrayList;
import java.util.List;

public class WindowCallbackInstrumentation {
    private final List<WindowListenerFactory> factories;

    public WindowCallbackInstrumentation(List<WindowListenerFactory> factories) {
        this.factories = factories;
    }

    public void interceptWindowCallback(Window window) {
        Window.Callback callback = window.getCallback();
        if (callback == null) {
            callback = new DefaultWindowCallback();
        }
        ArrayList<OnTouchEventListener> touchEventListeners = new ArrayList<OnTouchEventListener>();
        ArrayList<OnKeyEventListener> keyEventListeners = new ArrayList<OnKeyEventListener>();
        for (WindowListenerFactory factory : this.factories) {
            OnKeyEventListener keyEventListener;
            OnTouchEventListener listener = factory.generateOnTouchEventListener(window);
            if (listener != null) {
                touchEventListeners.add(listener);
            }
            if ((keyEventListener = factory.generateOnKeyEventListener()) == null) continue;
            keyEventListeners.add(keyEventListener);
        }
        WindowCallbackWrapper newCallback = new WindowCallbackWrapper(callback, new WindowEventSegmentation(touchEventListeners, keyEventListeners));
        window.setCallback((Window.Callback)newCallback);
    }
}

