/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.SessionReplayComponentProvider;
import com.dynatrace.android.agent.UserActionModifier;
import com.dynatrace.android.agent.comm.CommunicationProblemListener;
import com.dynatrace.android.agent.conf.AgentMode;
import com.dynatrace.android.agent.conf.BuilderUtil;
import com.dynatrace.android.agent.conf.ComposeDependencyChecker;
import com.dynatrace.android.agent.conf.Configuration;
import com.dynatrace.android.agent.conf.ConfigurationPreset;
import com.dynatrace.android.agent.conf.InstrumentationFlavor;
import com.dynatrace.android.agent.util.Utility;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;

public class ConfigurationBuilder {
    protected static final String LOGTAG = Global.LOG_PREFIX + "ConfigurationBuilder";
    private final AgentMode mode;
    private final String applicationId;
    private final String beaconUrl;
    private boolean certificateValidation;
    private KeyStore keyStore;
    private KeyManager[] keyManagers;
    private boolean crashReporting;
    private String[] monitoredDomains = new String[0];
    private String[] monitoredHttpsDomains = new String[0];
    private boolean hybridApp;
    private boolean fileDomainCookies;
    private boolean debugLogLevel;
    private CommunicationProblemListener communicationProblemListener;
    private boolean userOptIn;
    private boolean startupLoadBalancing;
    private boolean activityMonitoring;
    private UserActionModifier autoUserActionModifier = null;
    private final int graceTime;
    private final int waitTime;
    private final boolean sendEmptyAction;
    private final boolean namePrivacy;
    private final boolean applicationMonitoring;
    private final boolean webRequestTiming;
    private final boolean autoStart;
    private final InstrumentationFlavor instrumentationFlavor;
    private final SessionReplayComponentProvider sessionReplayComponentProvider;
    private final boolean isRageTapDetectionEnabled;

    ConfigurationBuilder(AgentMode mode, String applicationId, String beaconUrl) {
        this(mode, applicationId, beaconUrl, new ConfigurationPreset());
    }

    protected ConfigurationBuilder(AgentMode mode, String applicationId, String beaconUrl, ConfigurationPreset configPreset) {
        this.mode = mode;
        this.applicationId = applicationId;
        this.beaconUrl = beaconUrl;
        this.withCertificateValidation(configPreset.getCertificateValidation());
        this.withHybridMonitoring(configPreset.getHybridApp());
        this.withFileDomainCookies(configPreset.getFileDomainCookies());
        this.withDebugLogging(configPreset.getDebugLogLevel());
        this.withUserOptIn(configPreset.getUserOptIn());
        this.withMonitoredDomains(configPreset.getMonitoredDomains());
        this.withMonitoredHttpsDomains(configPreset.getMonitoredHttpsDomains());
        this.withStartupLoadBalancing(configPreset.getStartupLoadBalancing());
        this.graceTime = configPreset.getGraceTime();
        this.waitTime = configPreset.getWaitTime();
        this.applicationMonitoring = configPreset.getApplicationMonitoring();
        this.activityMonitoring = configPreset.getActivityMonitoring();
        this.webRequestTiming = configPreset.getWebRequestTiming();
        this.autoStart = configPreset.getAutoStart();
        this.crashReporting = configPreset.getCrashReporting();
        this.sendEmptyAction = configPreset.getSendEmptyActions();
        this.namePrivacy = configPreset.getNamePrivacy();
        this.communicationProblemListener = null;
        this.keyStore = null;
        this.keyManagers = null;
        this.instrumentationFlavor = configPreset.getInstrumentationFlavor();
        this.sessionReplayComponentProvider = configPreset.getSessionReplayComponentProvider();
        this.isRageTapDetectionEnabled = configPreset.isRageTapDetectionEnabled();
    }

    @Deprecated
    public ConfigurationBuilder withCertificateValidation(boolean enabled) {
        this.certificateValidation = enabled;
        return this;
    }

    @Deprecated
    public ConfigurationBuilder withKeyStore(KeyStore keyStore) {
        this.keyStore = keyStore;
        return this;
    }

    @Deprecated
    public ConfigurationBuilder withKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
        return this;
    }

    public ConfigurationBuilder withMonitoredDomains(String ... monitoredDomains) {
        String[] newValue = BuilderUtil.trimStrings(monitoredDomains);
        if (newValue != null) {
            this.monitoredDomains = newValue;
        }
        return this;
    }

    public ConfigurationBuilder withMonitoredHttpsDomains(String ... monitoredHttpsDomains) {
        String[] newValue = BuilderUtil.trimStrings(monitoredHttpsDomains);
        if (newValue != null) {
            this.monitoredHttpsDomains = newValue;
        }
        return this;
    }

    public ConfigurationBuilder withHybridMonitoring(boolean enabled) {
        this.hybridApp = enabled;
        return this;
    }

    public ConfigurationBuilder withFileDomainCookies(boolean fileDomainCookies) {
        this.fileDomainCookies = fileDomainCookies;
        return this;
    }

    public ConfigurationBuilder withDebugLogging(boolean enabled) {
        this.debugLogLevel = enabled;
        return this;
    }

    public ConfigurationBuilder withUserOptIn(boolean enabled) {
        this.userOptIn = enabled;
        return this;
    }

    public ConfigurationBuilder withStartupLoadBalancing(boolean enabled) {
        if (this.mode != AgentMode.APP_MON) {
            this.startupLoadBalancing = enabled;
        }
        return this;
    }

    public ConfigurationBuilder withCrashReporting(boolean enabled) {
        this.crashReporting = enabled;
        return this;
    }

    public ConfigurationBuilder withCommunicationProblemListener(CommunicationProblemListener listener) {
        this.communicationProblemListener = listener;
        return this;
    }

    public ConfigurationBuilder withActivityMonitoring(boolean enabled) {
        this.activityMonitoring = enabled;
        return this;
    }

    public ConfigurationBuilder withAutoUserActionModifier(UserActionModifier modifier) {
        this.autoUserActionModifier = modifier;
        return this;
    }

    public Configuration buildConfiguration() {
        String errorMsg = "discard invalid configuration";
        if (this.beaconUrl == null || this.mode == null) {
            if (this.debugLogLevel) {
                Utility.zlogE((String)LOGTAG, (String)"discard invalid configuration");
            }
            return null;
        }
        String verifiedBeaconUrl = BuilderUtil.getVerifiedBeaconUrl(this.beaconUrl);
        if (verifiedBeaconUrl == null) {
            if (this.debugLogLevel) {
                Utility.zlogE((String)LOGTAG, (String)("invalid value for the beacon url \"" + this.beaconUrl + "\""));
                Utility.zlogE((String)LOGTAG, (String)"discard invalid configuration");
            }
            return null;
        }
        String trimmedAppId = BuilderUtil.trimString(this.applicationId);
        if (trimmedAppId == null) {
            if (this.debugLogLevel) {
                Utility.zlogE((String)LOGTAG, (String)("invalid value for application id \"" + this.applicationId + "\""));
                Utility.zlogE((String)LOGTAG, (String)"discard invalid configuration");
            }
            return null;
        }
        String truncatedAppId = Utility.truncateString((String)trimmedAppId, (int)250);
        String appIdEncoded = Utility.urlEncode((String)truncatedAppId).replaceAll("_", "%5F");
        InstrumentationFlavor resolvedFlavor = this.instrumentationFlavor == InstrumentationFlavor.PLAIN && ComposeDependencyChecker.hasComposeDependency() ? InstrumentationFlavor.JETPACK_COMPOSE : this.instrumentationFlavor;
        return new Configuration(truncatedAppId, appIdEncoded, verifiedBeaconUrl, this.mode, this.certificateValidation, this.keyStore, this.keyManagers, this.graceTime, this.waitTime, this.sendEmptyAction, this.namePrivacy, this.applicationMonitoring, this.activityMonitoring, this.crashReporting, this.webRequestTiming, this.monitoredDomains, this.monitoredHttpsDomains, this.hybridApp, this.fileDomainCookies, this.debugLogLevel, this.autoStart, this.communicationProblemListener, this.userOptIn, this.startupLoadBalancing, resolvedFlavor, this.sessionReplayComponentProvider, this.isRageTapDetectionEnabled, this.autoUserActionModifier);
    }
}

