/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.lifecycle.activitytracking;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.activitytracking.ActiveActivityListener;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetrics;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsCollector;
import com.dynatrace.android.lifecycle.activitytracking.metrics.ScreenMetricsListener;
import com.dynatrace.android.lifecycle.callback.ComponentIdentifier;
import com.dynatrace.android.lifecycle.callback.ComponentIdentity;
import java.util.LinkedList;

public class ActiveActivityTracker
implements Application.ActivityLifecycleCallbacks {
    private static final String LOG_TAG = Global.LOG_PREFIX + "ActiveActivityTracker";
    private final ComponentIdentifier<Activity> componentIdentifier;
    private final ActiveActivityListener activeActivityListener;
    private final ScreenMetricsCollector screenMetricsCollector;
    private final ScreenMetricsListener metricsListener;
    private final LinkedList<ComponentIdentity> resumedActivities = new LinkedList();
    private ComponentIdentity lastReportedActivity;

    public ActiveActivityTracker(ComponentIdentifier<Activity> componentIdentifier, ActiveActivityListener activeActivityListener, ScreenMetricsCollector screenMetricsCollector, ScreenMetricsListener metricsListener) {
        this.componentIdentifier = componentIdentifier;
        this.activeActivityListener = activeActivityListener;
        this.screenMetricsCollector = screenMetricsCollector;
        this.metricsListener = metricsListener;
    }

    public void onActivityResumed(Activity activity) {
        ComponentIdentity resumedActivity = this.componentIdentifier.obtainIdentity(activity);
        if (!resumedActivity.equals(this.lastReportedActivity)) {
            this.resumedActivities.addFirst(resumedActivity);
            this.reportActivityChange(resumedActivity);
        }
    }

    public void onActivityPaused(Activity activity) {
        ComponentIdentity pausedActivity = this.componentIdentifier.obtainIdentity(activity);
        this.resumedActivities.remove(pausedActivity);
        if (this.resumedActivities.size() > 0) {
            this.reportActivityChange(this.resumedActivities.peekFirst());
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.resumedActivities.size() == 0) {
            this.reportActivityChange(null);
        }
    }

    private void reportActivityChange(ComponentIdentity activityId) {
        if (this.lastReportedActivity == activityId) {
            return;
        }
        if (Global.DEBUG) {
            if (activityId == null) {
                Utility.zlogD(LOG_TAG, "unset current activity");
            } else {
                Utility.zlogD(LOG_TAG, "set current activity to " + activityId.getComponentName());
            }
        }
        if (activityId == null) {
            this.activeActivityListener.onActiveActivityChanged(null);
        } else {
            this.activeActivityListener.onActiveActivityChanged(activityId.getComponentName());
        }
        this.lastReportedActivity = activityId;
    }

    LinkedList<ComponentIdentity> getResumedActivities() {
        return this.resumedActivities;
    }

    ComponentIdentity getLastReportedActivity() {
        return this.lastReportedActivity;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        ScreenMetrics screenMetrics = this.screenMetricsCollector.collectMetrics(activity);
        this.metricsListener.onScreenMetrics(screenMetrics);
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

