/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.events.lifecycle.DisplaySegment;
import com.dynatrace.android.agent.events.lifecycle.DisplaySegmentFactory;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.action.LifecycleAction;
import com.dynatrace.android.lifecycle.action.LifecycleActionObserver;
import com.dynatrace.android.lifecycle.event.ActivityEventType;
import com.dynatrace.android.useraction.LifecyclePlaceholderSegment;
import com.dynatrace.android.useraction.UserAction;

public class StoreActionObserver
implements LifecycleActionObserver {
    private static final String LOG_TAG = Global.LOG_PREFIX + "StoreActionObserver";

    @Override
    public void onActivityLifecycleAction(LifecycleAction<ActivityEventType> action) {
        UserAction parentAction = action.getParentAction();
        if (parentAction == null || parentAction.isFinalized()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "Parent action is not available anymore, discard lifecycle action '" + action.getName() + "'");
            }
            return;
        }
        if (Dynatrace.getCaptureStatus()) {
            DisplaySegment displaySegment = new DisplaySegmentFactory().createSegment(action, parentAction.getSession(), parentAction.getServerId());
            Core.saveSegment(displaySegment);
        }
        LifecyclePlaceholderSegment placeholder = action.getPlaceholderSegment();
        Core.removeFromCalloutTable(placeholder);
        placeholder.leaveAction();
    }
}

