/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.lifecycle;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.DTXAutoAction;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.events.lifecycle.AppStartSegment;
import com.dynatrace.android.agent.events.lifecycle.AppStartSegmentFactory;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.lifecycle.appstart.AppStartAction;
import com.dynatrace.android.lifecycle.appstart.AppStartActionObserver;
import com.dynatrace.android.useraction.AppStartPlaceholderSegment;
import com.dynatrace.android.useraction.UserAction;

public class AppStartActionObserverImpl
implements AppStartActionObserver {
    private static final String LOG_TAG = Global.LOG_PREFIX + "AppStartActionObserverImpl";
    private final AppStartSegmentFactory segmentFactory = new AppStartSegmentFactory();

    @Override
    public void onAppStartCompleted(AppStartAction appStartAction) {
        DTXAutoAction action;
        UserAction parentAction = appStartAction.getParentAction();
        if (parentAction == null || parentAction.isFinalized()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "Parent action is not available anymore, discard action '" + appStartAction.getName() + "'");
            }
            return;
        }
        if (!AdkSettings.getInstance().getConfiguration().activityMonitoring && (action = DTXAutoAction.getAutoAction()) != null) {
            action.cancelTimer();
        }
        if (Dynatrace.getCaptureStatus()) {
            AppStartSegment segment = this.segmentFactory.createSegment(appStartAction, parentAction.getSession(), parentAction.getServerId());
            Core.saveSegment(segment);
        }
        AppStartPlaceholderSegment placeholderSegment = appStartAction.getPlaceholderSegment();
        Core.removeFromCalloutTable(placeholderSegment);
        placeholderSegment.leaveAction();
        parentAction.startTimerIfNeeded();
    }
}

