/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.ragetap.detection;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.ragetap.detection.RageTap;
import com.dynatrace.android.ragetap.detection.RageTapListener;
import com.dynatrace.android.ragetap.detection.RageTapRules;
import com.dynatrace.android.ragetap.detection.TapData;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RageTapDetector {
    private static final String LOG_TAG = Global.LOG_PREFIX + "RageTapDetector";
    private final RageTapListener listener;
    private final ScheduledExecutorService executor;
    private final Runnable timeoutTask;
    private final TimeLineProvider timeLineProvider;
    private Session session;
    private RageTapRules rules;
    private TapData firstTap = null;
    private TapData lastTap = null;
    private int numOfTaps = 0;
    private ScheduledFuture<?> scheduledTask;
    private long timeout;

    public RageTapDetector(RageTapListener listener, ScheduledExecutorService executor, TimeLineProvider timeLineProvider) {
        this.listener = listener;
        this.executor = executor;
        this.timeLineProvider = timeLineProvider;
        this.timeoutTask = new Runnable(){

            @Override
            public void run() {
                RageTapDetector.this.onTimespanTimeout();
            }
        };
    }

    public synchronized void onNewSession(Session session) {
        if (this.session != null) {
            this.evaluateAndReset(false);
        }
        this.session = session;
        this.rules = new RageTapRules(session.getRageTapConfiguration());
        this.timeout = session.getRageTapConfiguration().getTimespanDifference();
    }

    public synchronized void onTimespanTimeout() {
        if (this.firstTap == null) {
            return;
        }
        long timeNow = this.timeLineProvider.now();
        if (this.rules.exceedsTimespanDifference(this.lastTap, timeNow)) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "timespan difference exceeded");
            }
            this.evaluateAndReset();
        } else {
            if (this.scheduledTask != null) {
                this.scheduledTask.cancel(false);
            }
            this.scheduledTask = this.scheduleTimeoutTask();
        }
    }

    public synchronized void evaluateAndReset() {
        this.evaluateAndReset(true);
    }

    private void evaluateAndReset(boolean evaluateSessionSplit) {
        if (this.rules.hasMinimumNumberOfTaps(this.numOfTaps)) {
            RageTap rageTap = new RageTap(this.firstTap, this.lastTap, this.numOfTaps);
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "rage tap detected: " + rageTap);
            }
            this.listener.onRageTap(this.session, rageTap, evaluateSessionSplit);
        }
        this.reset();
    }

    public synchronized void onTapDetected(TapData tap) {
        if (Global.DEBUG) {
            Utility.zlogD(LOG_TAG, "register tap: " + tap);
        }
        if (this.rules.exceedsTapDuration(tap)) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "tap exceeds click duration");
            }
            this.evaluateAndReset();
            return;
        }
        if (this.firstTap == null) {
            this.registerFirstTap(tap);
            return;
        }
        if (this.rules.exceedsTimespanDifference(this.lastTap, tap)) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "tap exceeds timespan difference");
            }
            this.evaluateAndReset();
            this.registerFirstTap(tap);
            return;
        }
        if (this.rules.exceedsDispersionRadius(this.lastTap, tap)) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "tap exceeds dispersion radius");
            }
            this.evaluateAndReset();
            this.registerFirstTap(tap);
            return;
        }
        this.lastTap = tap;
        ++this.numOfTaps;
        if (this.rules.hasMinimumNumberOfTaps(this.numOfTaps)) {
            if (this.scheduledTask != null) {
                this.scheduledTask.cancel(false);
            }
            this.scheduledTask = this.scheduleTimeoutTask();
        }
    }

    private ScheduledFuture<?> scheduleTimeoutTask() {
        return this.executor.schedule(this.timeoutTask, this.timeout, TimeUnit.MILLISECONDS);
    }

    private void reset() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel(false);
            this.scheduledTask = null;
        }
        this.firstTap = null;
        this.lastTap = null;
        this.numOfTaps = 0;
    }

    private void registerFirstTap(TapData parseTap) {
        if (this.session.getSessionStartTime() > parseTap.getTapDown().getTimestamp()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOG_TAG, "discard tap because it partially occurred outside of the session");
            }
            this.reset();
            return;
        }
        this.firstTap = parseTap;
        this.lastTap = parseTap;
        this.numOfTaps = 1;
    }
}

