/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.cloudevents.v1;

import android.os.Build;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.cloudevents.v1.CloudEventImpl;
import com.dynatrace.android.internal.api.cloudevents.v1.CloudEvent;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CloudEventBuilder {
    public static final String DEFAULT_SPEC_VERSION = "1.0";
    public static final Set<String> RESERVED_ATTRIBUTE_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("id", "source", "specversion", "type", "datacontenttype", "dataschema", "subject", "time", "data", "dtcontext")));
    private static final String LOGTAG = Global.LOG_PREFIX + "CloudEventBuilder";
    private final String specVersion = "1.0";
    private final Map<String, Object> extensionContextAttributes = new LinkedHashMap<String, Object>();
    private final Pattern controlCharacterPattern = Pattern.compile("\\p{C}");
    private String id;
    private String source;
    private String type;
    private String dataContentType;
    private String dataSchema;
    private String subject;
    private String time;
    private String data;

    private boolean isLowerCaseAsciiLetter(char c) {
        return c >= 'a' && c <= 'z';
    }

    private boolean isAsciiDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private String valueOrNull(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    String formatTime(Calendar calendar) {
        SimpleDateFormat rfc3339Compliant = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        rfc3339Compliant.setTimeZone(calendar.getTimeZone());
        return rfc3339Compliant.format(calendar.getTime());
    }

    @Deprecated
    String formatTimePreAPI24(Calendar calendar) {
        SimpleDateFormat rfc3339Compliant = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        rfc3339Compliant.setTimeZone(calendar.getTimeZone());
        StringBuilder timeBuilder = new StringBuilder(rfc3339Compliant.format(calendar.getTime()));
        int offsetToUtcInMilliseconds = calendar.get(15) + calendar.get(16);
        if (offsetToUtcInMilliseconds == 0) {
            timeBuilder.append('Z');
        } else {
            int offsetToUtcInMinutes = offsetToUtcInMilliseconds / 60000;
            if (offsetToUtcInMinutes >= 0) {
                timeBuilder.append('+');
            } else {
                timeBuilder.append('-');
                offsetToUtcInMinutes = -offsetToUtcInMinutes;
            }
            timeBuilder.append(String.format("%02d:%02d", offsetToUtcInMinutes / 60, offsetToUtcInMinutes % 60)).toString();
        }
        return timeBuilder.toString();
    }

    public CloudEventBuilder withId(String id) {
        this.id = this.valueOrNull(id);
        return this;
    }

    public String getId() {
        return this.id;
    }

    public CloudEventBuilder withSource(String source) {
        this.source = this.valueOrNull(source);
        return this;
    }

    public String getSource() {
        return this.source;
    }

    public String getSpecVersion() {
        return DEFAULT_SPEC_VERSION;
    }

    public CloudEventBuilder withType(String type) {
        this.type = this.valueOrNull(type);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CloudEventBuilder withDataContentType(String dataContentType) {
        this.dataContentType = this.valueOrNull(dataContentType);
        return this;
    }

    public String getDataContentType() {
        if (this.dataContentType != null) {
            return this.dataContentType;
        }
        if (this.data != null && !this.data.isEmpty()) {
            return "application/json";
        }
        return null;
    }

    public CloudEventBuilder withDataSchema(String dataSchema) {
        this.dataSchema = this.valueOrNull(dataSchema);
        return this;
    }

    public String getDataSchema() {
        return this.dataSchema;
    }

    public CloudEventBuilder withSubject(String subject) {
        this.subject = this.valueOrNull(subject);
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public CloudEventBuilder withTime(Calendar calendar) {
        if (calendar == null) {
            this.time = null;
            return this;
        }
        this.time = Build.VERSION.SDK_INT < 24 ? this.formatTimePreAPI24(calendar) : this.formatTime(calendar);
        return this;
    }

    public String getTime() {
        return this.time;
    }

    public CloudEventBuilder withExtensionContextAttribute(String name, String value) {
        this.extensionContextAttributes.put(name, value);
        return this;
    }

    public CloudEventBuilder withExtensionContextAttribute(String name, Number value) {
        this.extensionContextAttributes.put(name, value);
        return this;
    }

    public CloudEventBuilder withExtensionContextAttribute(String name, Boolean value) {
        this.extensionContextAttributes.put(name, value);
        return this;
    }

    public Map<String, Object> getExtensionContextAttributes() {
        return Collections.unmodifiableMap(this.extensionContextAttributes);
    }

    public CloudEventBuilder withData(String data) {
        this.data = data;
        return this;
    }

    public CloudEventBuilder withJsonData(String jsonDataAsString) {
        return this.withDataContentType("application/json").withData(jsonDataAsString);
    }

    public CloudEventBuilder withJsonData(JSONObject jsonObject) {
        return this.withJsonData(jsonObject.toString());
    }

    public CloudEventBuilder withJsonData(JSONArray jsonArray) {
        return this.withJsonData(jsonArray.toString());
    }

    public String getData() {
        return this.data;
    }

    public CloudEvent buildOrNull() {
        if (!this.requiredAttributesAreValid()) {
            return null;
        }
        if (!this.attributeValuesAreValid()) {
            return null;
        }
        if (!this.extensionContextAttributesAreValid()) {
            return null;
        }
        if (!this.dataIsValid()) {
            return null;
        }
        return new CloudEventImpl(this);
    }

    private boolean requiredAttributesAreValid() {
        if (this.id == null || this.controlCharacterPattern.matcher(this.id).find()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "attribute `id` is null or contains illegal characters");
            }
            return false;
        }
        if (this.source == null || this.controlCharacterPattern.matcher(this.source).find()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "attribute `source` is null or contains illegal characters");
            }
            return false;
        }
        if (this.type == null || this.controlCharacterPattern.matcher(this.type).find()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "attribute `type` is null or contains illegal characters");
            }
            return false;
        }
        return true;
    }

    private boolean attributeValuesAreValid() {
        if (this.dataContentType != null && this.controlCharacterPattern.matcher(this.dataContentType).find()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "attribute `dataContentType` contains illegal characters");
            }
            return false;
        }
        if (this.dataSchema != null && this.controlCharacterPattern.matcher(this.dataSchema).find()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "attribute `dataSchema` contains illegal characters");
            }
            return false;
        }
        if (this.subject != null && this.controlCharacterPattern.matcher(this.subject).find()) {
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, "attribute `subject` contains illegal characters");
            }
            return false;
        }
        return true;
    }

    private boolean extensionContextAttributesAreValid() {
        for (String extensionContextAttributeName : this.extensionContextAttributes.keySet()) {
            if (RESERVED_ATTRIBUTE_NAMES.contains(extensionContextAttributeName)) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, "extension context attribute \"" + extensionContextAttributeName + "\" is reserved");
                }
                return false;
            }
            if (extensionContextAttributeName.length() > 20) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, "extension context attribute \"" + extensionContextAttributeName + "\" exceeds the max length of 20 characters");
                }
                return false;
            }
            for (int i = 0; i < extensionContextAttributeName.length(); ++i) {
                char c = extensionContextAttributeName.charAt(i);
                if (this.isLowerCaseAsciiLetter(c) || this.isAsciiDigit(c)) continue;
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, "extension context attribute \"" + extensionContextAttributeName + "\" contains invalid characters");
                }
                return false;
            }
            Object value = this.extensionContextAttributes.get(extensionContextAttributeName);
            if (!(value instanceof String) || !this.controlCharacterPattern.matcher((String)value).find()) continue;
            return false;
        }
        return true;
    }

    private boolean dataIsValid() {
        if (this.data != null && !this.data.isEmpty() && "application/json".equals(this.getDataContentType())) {
            try {
                new JSONObject(this.data);
            }
            catch (JSONException ex) {
                try {
                    new JSONArray(this.data);
                }
                catch (JSONException ex1) {
                    if (Global.DEBUG) {
                        Utility.zlogD(LOGTAG, "event data is not valid JSON data");
                    }
                    return false;
                }
            }
            return true;
        }
        return true;
    }
}

