/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.internal.api.cloudevents.v1;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.CloudEventSegment;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Dynatrace;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.cloudevents.v1.CloudEventSerializer;
import com.dynatrace.android.internal.api.cloudevents.v1.CloudEvent;

public final class CloudEventApi {
    private static final String LOGTAG = Global.LOG_PREFIX + "CloudEventApi";

    public static void reportCloudEvent(CloudEvent cloudEvent) {
        if (cloudEvent == null || !Dynatrace.getCaptureStatus()) {
            return;
        }
        Session session = Session.determineActiveSessionForInternalEvent();
        int serverId = AdkSettings.getInstance().serverId;
        String payload = new CloudEventSerializer(cloudEvent).serialize();
        if (payload.length() < 65536) {
            String encodedPayload = Utility.urlEncode(payload);
            Core.saveSegment(new CloudEventSegment(session, serverId, encodedPayload));
        } else if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, "serialized CloudEvent must be less than 65536 characters, got " + payload.length() + " instead.");
        }
    }
}

