/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Global;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

@SuppressLint(value={"SimpleDateFormat"})
public class Utility {
    private static final String LOGTAG = Global.LOG_PREFIX + "Utility";
    private static AtomicInteger eventSeqNumber = new AtomicInteger(1);
    private static AtomicLong nextTagId = new AtomicLong(0L);

    public static long getNextTagId() {
        return nextTagId.incrementAndGet();
    }

    public static int getEventSeqNum() {
        return eventSeqNumber.getAndIncrement();
    }

    public static void resetEventSeqNum() {
        eventSeqNumber.set(1);
    }

    public static int getAppTargetSdk(Context context) {
        int version = 0;
        if (context == null) {
            return version;
        }
        try {
            ApplicationInfo applInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 0);
            if (applInfo != null) {
                version = applInfo.targetSdkVersion;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCPUInfo() {
        String cpuInfo = "";
        Process process = null;
        InputStream isPipe = null;
        try {
            String sS = "";
            String[] sArgs = new String[]{"/system/bin/cat", "/proc/cpuinfo"};
            ProcessBuilder pbCmd = new ProcessBuilder(sArgs);
            process = pbCmd.start();
            isPipe = process.getInputStream();
            byte[] byRead = new byte[1024];
            while (isPipe.read(byRead) != -1) {
                sS = sS + new String(byRead).trim();
            }
            String[] sArr = sS.split("\n");
            if (sArr == null || sArr.length < 1) {
                String string = cpuInfo;
                return string;
            }
            for (String line : sArr) {
                String result = Utility.parseCpuInfo(line);
                if (result == null) continue;
                cpuInfo = result;
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (process != null) {
                process.destroy();
            }
            if (isPipe != null) {
                try {
                    isPipe.close();
                }
                catch (IOException iOException) {}
            }
        }
        return cpuInfo;
    }

    private static String parseCpuInfo(String line) {
        if (line == null) {
            return null;
        }
        String cpuInfo = null;
        String[] toks = line.split(":");
        if (toks != null && toks.length > 1 && toks[0] != null) {
            String PROC = "Processor";
            if (toks[0].startsWith("Processor")) {
                cpuInfo = toks[1] == null ? null : toks[1].replaceAll(" Processor ", " ").trim();
            } else if (toks[0].startsWith("vendor_id")) {
                cpuInfo = toks[1] == null ? null : toks[1].trim();
            }
        }
        return cpuInfo;
    }

    public static boolean isValidEventName(String eventName, int maxLen) {
        if (eventName == null) {
            return false;
        }
        int len = (eventName = eventName.trim()).length();
        return len >= 1 && len <= maxLen;
    }

    public static String trimString(String value, int maxLen) {
        if (value == null) {
            return null;
        }
        if (value.length() > maxLen) {
            value = value.substring(0, maxLen);
        }
        return value;
    }

    public static String trimWebRequest(String url) {
        if (url == null) {
            return null;
        }
        int maxLen = 250;
        int idx = url.indexOf("?");
        if (idx < 0 || maxLen < idx) {
            idx = maxLen;
        }
        if (url.length() > idx) {
            return url.substring(0, idx);
        }
        return url;
    }

    public static int parseInt(String debugName, String value, int lowerLimit, int upperLimit, int defaultValue, boolean useDefaultValueForExceededLimit) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            int intValue = Integer.parseInt(value);
            if (intValue < lowerLimit) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, String.format("%s value of %s is not within the range of %s and %s", debugName, value, lowerLimit, upperLimit));
                }
                return useDefaultValueForExceededLimit ? defaultValue : lowerLimit;
            }
            if (intValue > upperLimit) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, String.format("%s value of %s is not within the range of %s and %s", debugName, value, lowerLimit, upperLimit));
                }
                return useDefaultValueForExceededLimit ? defaultValue : upperLimit;
            }
            return intValue;
        }
        catch (NumberFormatException nfe) {
            if (Global.DEBUG) {
                Utility.zlogE(LOGTAG, debugName, nfe);
            }
            return defaultValue;
        }
    }

    public static int parseInt(String debugName, String value, int lowerLimit, int upperLimit, int defaultValue) {
        return Utility.parseInt(debugName, value, lowerLimit, upperLimit, defaultValue, false);
    }

    public static int parseInt(Map<String, String> map, String key, int lowerLimit, int upperLimit, int defaultValue, boolean useDefaultValueForExceededLimit) {
        return Utility.parseInt(key, map.get(key), lowerLimit, upperLimit, defaultValue, useDefaultValueForExceededLimit);
    }

    public static int parseInt(Map<String, String> map, String key, int lowerLimit, int upperLimit, int defaultValue) {
        return Utility.parseInt(key, map.get(key), lowerLimit, upperLimit, defaultValue);
    }

    public static Long parseLong(String longName, String longStr, long lowerLimit, long upperLimit) {
        if (longStr == null) {
            return null;
        }
        Long value = null;
        try {
            value = Long.valueOf(longStr.trim());
        }
        catch (NumberFormatException nfe) {
            if (Global.DEBUG) {
                Utility.zlogE(LOGTAG, longName, nfe);
            }
            return null;
        }
        if (value < lowerLimit || value > upperLimit) {
            value = null;
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("%s value of %s is not within the range of %s and %s", longName, longStr, lowerLimit, upperLimit));
            }
        }
        return value;
    }

    public static Float parseFloat(String floatName, String floatStr, float lowerLimit, float upperLimit) {
        Float value;
        block5: {
            value = null;
            if (floatStr == null) {
                return null;
            }
            try {
                value = Float.valueOf(Float.valueOf(floatStr.trim()).floatValue());
            }
            catch (NumberFormatException nfe) {
                if (!Global.DEBUG) break block5;
                Utility.zlogE(LOGTAG, floatName, nfe);
            }
        }
        if (!(value == null || value.floatValue() >= lowerLimit && value.floatValue() <= upperLimit)) {
            value = null;
            if (Global.DEBUG) {
                Utility.zlogD(LOGTAG, String.format("%s value of %s is not within the range of %s and %s", floatName, floatStr, Float.valueOf(lowerLimit), Float.valueOf(upperLimit)));
            }
        }
        return value;
    }

    public static byte[] readStream(InputStream is) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((count = is.read(buffer)) != -1) {
            baos.write(buffer, 0, count);
        }
        return baos.toByteArray();
    }

    public static boolean hasPermissions(Context ctx) {
        Context context = ctx;
        if (context == null) {
            context = AdkSettings.getInstance().getContext();
        }
        if (context == null) {
            return false;
        }
        String errorMsg = "Mobile agent failed permissions check.  Permissions needed: %s isIsolated: %s";
        try {
            context.registerReceiver(null, new IntentFilter());
        }
        catch (RuntimeException e) {
            if (Global.DEBUG) {
                Utility.zlogE(LOGTAG, String.format(errorMsg, Arrays.toString(Global.REQUIRED_PERMISSIONS), true));
            }
            return false;
        }
        return true;
    }

    public static String urlEncode(String data) {
        if (data == null) {
            return null;
        }
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            if (Global.DEBUG) {
                Utility.zlogE(LOGTAG, e.toString());
            }
            return data.replaceAll("&", "%26").replaceAll("=", "%3D");
        }
    }

    public static Map<String, String> parseKeyValueString(String keyValueString) {
        String[] entries;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : entries = keyValueString.split("&")) {
            String[] values = entry.split("=");
            if (values.length != 2) {
                return null;
            }
            map.put(values[0], values[1]);
        }
        return map;
    }

    public static void zlogD(String logTag, String logMessage) {
        int startIndex;
        String msg = Utility.getThreadId() + logMessage;
        int maxLength = 4000;
        int lines = (msg.length() - 1) / maxLength;
        for (startIndex = 0; startIndex < lines; ++startIndex) {
            Log.d((String)logTag, (String)msg.substring(startIndex * maxLength, (startIndex + 1) * maxLength));
        }
        Log.d((String)logTag, (String)msg.substring(startIndex * maxLength));
    }

    public static void zlogD(String logTag, String logMessage, Throwable e) {
        Log.d((String)logTag, (String)(Utility.getThreadId() + logMessage), (Throwable)e);
    }

    public static void zlogE(String logTag, String logMessage) {
        Log.e((String)logTag, (String)(Utility.getThreadId() + logMessage));
    }

    public static void zlogE(String logTag, String logMessage, Throwable e) {
        Log.e((String)logTag, (String)(Utility.getThreadId() + logMessage), (Throwable)e);
    }

    public static void zlogW(String logTag, String logMessage) {
        Log.w((String)logTag, (String)(Utility.getThreadId() + logMessage));
    }

    public static void zlogI(String logTag, String logMessage) {
        Log.i((String)logTag, (String)(Utility.getThreadId() + logMessage));
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String getThreadId() {
        return String.format("#%d.", Thread.currentThread().getId());
    }
}

