/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.metrics;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.RootDetector;
import com.dynatrace.android.agent.TimeLineProvider;
import com.dynatrace.android.agent.metrics.ConnectionType;
import com.dynatrace.android.agent.util.Utility;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;

public class AndroidMetrics {
    private static final String LOGTAG = Global.LOG_PREFIX + "AndroidMetrics";
    private static volatile AndroidMetrics theInstance = null;
    public Long deviceMemorySize;
    public String manufacturer;
    public String userLang;
    public boolean deviceRooted;
    public String deviceCarrier;
    public volatile ConnectionType connectionType = ConnectionType.OFFLINE;
    public volatile int screenWidth;
    public volatile int screenHeight;
    public volatile int screenDensityDpi;
    public volatile float screenDensity;
    public String networkProtocol = null;
    public int deviceOrientation = 0;
    public String operatingSystem;
    public String cpuInformation;
    public int batteryLevel = -1;
    public Long deviceMemoryFree;
    public String modelId;
    private String currentActivityName;
    private Context context;

    public AndroidMetrics(Context ctx) {
        this.context = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AndroidMetrics getInstance() {
        if (theInstance != null) return theInstance;
        Class<AndroidMetrics> clazz = AndroidMetrics.class;
        synchronized (AndroidMetrics.class) {
            if (theInstance != null) return theInstance;
            theInstance = new AndroidMetrics(AdkSettings.getInstance().getContext());
            theInstance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public static String formatUserLanguage(Locale locale) {
        String userLang = locale.getLanguage();
        if (locale.getCountry().length() > 0) {
            userLang = userLang + "_" + locale.getCountry();
        }
        return userLang;
    }

    private void init() {
        this.manufacturer = Utility.trimString(Build.MANUFACTURER != null ? Build.MANUFACTURER : "unknown", 250);
        this.deviceRooted = RootDetector.isDeviceRooted();
        this.operatingSystem = "Android " + Build.VERSION.RELEASE;
        this.cpuInformation = Utility.getCPUInfo();
        this.modelId = Build.MODEL;
        this.userLang = AndroidMetrics.formatUserLanguage(Locale.getDefault());
        this.updateVerboseMetrics();
        this.updateBasicMetrics();
        this.updateCommonMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVerboseMetrics() {
        Long updateStartTime = 0L;
        if (Global.DEBUG) {
            updateStartTime = TimeLineProvider.getSystemTime();
        }
        if (this.deviceMemorySize == null) {
            long memTotal = 0L;
            FileReader localFileReader = null;
            BufferedReader localBufferedReader = null;
            try {
                localFileReader = new FileReader("/proc/meminfo");
                localBufferedReader = new BufferedReader(localFileReader, 8192);
                String str1 = localBufferedReader.readLine();
                String[] arrayOfString = str1.split("\\s+");
                memTotal = Long.valueOf(arrayOfString[1]);
                localBufferedReader.close();
                localFileReader.close();
            }
            catch (IOException e) {
                if (Global.DEBUG) {
                    Utility.zlogD(LOGTAG, "Unable to measure total memory", e);
                }
            }
            finally {
                block25: {
                    block24: {
                        if (localFileReader != null) {
                            try {
                                localFileReader.close();
                            }
                            catch (IOException e) {
                                if (!Global.DEBUG) break block24;
                                Utility.zlogD(LOGTAG, "Could not close input stream", e);
                            }
                        }
                    }
                    if (localBufferedReader != null) {
                        try {
                            localBufferedReader.close();
                        }
                        catch (IOException e) {
                            if (!Global.DEBUG) break block25;
                            Utility.zlogD(LOGTAG, "Could not close input stream", e);
                        }
                    }
                }
            }
            this.deviceMemorySize = memTotal / 1024L;
        }
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("Verbose metrics updated in %s ms", TimeLineProvider.getSystemTime() - updateStartTime));
        }
    }

    public void updateBasicMetrics() {
        Long updateStartTime = 0L;
        if (Global.DEBUG) {
            updateStartTime = TimeLineProvider.getSystemTime();
        }
        this.updateCarrier();
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("Basic metrics updated in %s ms", TimeLineProvider.getSystemTime() - updateStartTime));
        }
    }

    public void updateCommonMetrics() {
        Long updateStartTime = 0L;
        if (Global.DEBUG) {
            updateStartTime = TimeLineProvider.getSystemTime();
        }
        this.updateConnInfo();
        this.updateScreenHeightAndWidth();
        if (this.context != null) {
            this.deviceOrientation = this.context.getResources().getConfiguration().orientation;
        }
        this.updateBatteryStrength();
        this.updateMemoryInfo();
        if (Global.DEBUG) {
            Utility.zlogD(LOGTAG, String.format("Common metrics updated in %s ms", TimeLineProvider.getSystemTime() - updateStartTime));
        }
    }

    private void updateCarrier() {
        block4: {
            if (this.context == null) {
                return;
            }
            this.deviceCarrier = null;
            try {
                TelephonyManager telephonyManager = (TelephonyManager)this.context.getSystemService("phone");
                String carrier = telephonyManager.getNetworkOperatorName();
                if (carrier != null) {
                    this.deviceCarrier = Utility.trimString(carrier != null ? carrier : "unknown", 250);
                }
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block4;
                Utility.zlogW(LOGTAG, e.toString());
            }
        }
    }

    private void updateConnInfo() {
        NetworkInfo nwInfo = this.getNetworkInfo();
        this.connectionType = this.getConnType(nwInfo);
        switch (this.connectionType) {
            case WIFI: {
                this.networkProtocol = "802.11x";
                break;
            }
            case MOBILE: {
                this.networkProtocol = this.getMobileNetworkProtocol(nwInfo);
                break;
            }
            case LAN: {
                this.networkProtocol = "Ethernet";
                break;
            }
            default: {
                this.networkProtocol = null;
            }
        }
    }

    private String getMobileNetworkProtocol(NetworkInfo nwInfo) {
        switch (nwInfo.getSubtype()) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return "3G";
            }
            case 13: 
            case 18: 
            case 19: {
                return "4G";
            }
            case 20: {
                return "5G";
            }
        }
        return nwInfo.getSubtypeName();
    }

    private void updateBatteryStrength() {
        Intent inBattIntent;
        if (this.context == null) {
            return;
        }
        try {
            inBattIntent = this.context.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
        catch (RuntimeException e) {
            if (Global.DEBUG) {
                Utility.zlogW(LOGTAG, "Isolated (sandboxed) process detected.");
            }
            return;
        }
        int iRawLevel = 0;
        int iScale = 0;
        int iLevel = -1;
        if (inBattIntent != null) {
            iRawLevel = inBattIntent.getIntExtra("level", -1);
            iScale = inBattIntent.getIntExtra("scale", -1);
        }
        if (iRawLevel >= 0 && iScale > 0) {
            iLevel = (int)(100.0 / (double)iScale * (double)iRawLevel);
        }
        this.batteryLevel = iLevel >= 0 && iLevel <= 100 ? iLevel : -1;
    }

    private void updateMemoryInfo() {
        ActivityManager aM = this.getActivityMgr();
        if (aM == null) {
            this.deviceMemoryFree = null;
            return;
        }
        ActivityManager.MemoryInfo mI = new ActivityManager.MemoryInfo();
        aM.getMemoryInfo(mI);
        this.deviceMemoryFree = mI.availMem / 0x100000L;
    }

    private void updateScreenHeightAndWidth() {
        Point point = new Point(this.screenWidth, this.screenHeight);
        if (this.context == null) {
            return;
        }
        Display display = ((WindowManager)this.context.getSystemService("window")).getDefaultDisplay();
        if (display == null) {
            return;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        if (Build.VERSION.SDK_INT <= 16) {
            display.getMetrics(metrics);
        } else {
            display.getRealMetrics(metrics);
        }
        this.screenDensityDpi = metrics.densityDpi;
        this.screenDensity = metrics.density;
        if (Build.VERSION.SDK_INT <= 16) {
            try {
                Method getRawHeightMethod = Display.class.getMethod("getRawHeight", new Class[0]);
                Method getRawWidthMethod = Display.class.getMethod("getRawWidth", new Class[0]);
                point.x = (Integer)getRawWidthMethod.invoke((Object)display, new Object[0]);
                point.y = (Integer)getRawHeightMethod.invoke((Object)display, new Object[0]);
            }
            catch (Exception e) {
                if (Global.DEBUG) {
                    Utility.zlogE(LOGTAG, "failed to read display metrics", e);
                }
            }
        } else {
            display.getRealSize(point);
        }
        if (point.x < point.y) {
            this.screenWidth = point.x;
            this.screenHeight = point.y;
        } else {
            this.screenWidth = point.y;
            this.screenHeight = point.x;
        }
    }

    private ActivityManager getActivityMgr() {
        ActivityManager aM;
        block2: {
            aM = null;
            try {
                aM = (ActivityManager)this.context.getSystemService("activity");
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block2;
                Utility.zlogW(LOGTAG, e.toString());
            }
        }
        return aM;
    }

    private NetworkInfo getNetworkInfo() {
        NetworkInfo nI;
        block3: {
            nI = null;
            if (this.context == null) {
                return nI;
            }
            try {
                ConnectivityManager cMgr = (ConnectivityManager)this.context.getSystemService("connectivity");
                nI = cMgr.getActiveNetworkInfo();
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block3;
                Utility.zlogW(LOGTAG, e.toString());
            }
        }
        return nI;
    }

    public boolean isNetworkAvailable() {
        boolean available;
        NetworkInfo nwInfo = this.getNetworkInfo();
        boolean bl = available = nwInfo != null && (nwInfo.isAvailable() || nwInfo.isConnected());
        if (!available && Global.DEBUG) {
            Utility.zlogI(LOGTAG, "Network connection is not available");
        }
        return available;
    }

    public ConnectionType getConnType() {
        return this.getConnType(this.getNetworkInfo());
    }

    public ConnectionType getConnType(NetworkInfo knownNwInfo) {
        if (knownNwInfo == null || !knownNwInfo.isAvailable() || !knownNwInfo.isConnected()) {
            return ConnectionType.OFFLINE;
        }
        switch (knownNwInfo.getType()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                return ConnectionType.MOBILE;
            }
            case 1: 
            case 13: {
                return ConnectionType.WIFI;
            }
            case 9: {
                return ConnectionType.LAN;
            }
        }
        return ConnectionType.OTHER;
    }

    public String getCurrentActivityName() {
        return this.currentActivityName;
    }

    public void setCurrentActivityName(String currentActivityName) {
        this.currentActivityName = currentActivityName;
    }
}

