/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.events.ragetap;

import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.events.ragetap.RageTapSegment;
import com.dynatrace.android.agent.util.Utility;
import com.dynatrace.android.ragetap.detection.RageTap;

public class RageTapSegmentFactory {
    public RageTapSegment createSegment(RageTap rageTap, String activityName, Session session, int serverId) {
        long absoluteSessionStartTime = session.getSessionStartTime();
        long relativeRageTapStart = rageTap.getFirstTap().getTapDown().getTimestamp() - absoluteSessionStartTime;
        long relativeRageTapEnd = rageTap.getLastTap().getTapUp().getTimestamp() - relativeRageTapStart - absoluteSessionStartTime;
        int sequenceNumber = Utility.getEventSeqNum();
        return new RageTapSegment.Builder().withActivityName(activityName).withSession(session).withServerId(serverId).withSequenceNumber(sequenceNumber).withFirstTapDown(relativeRageTapStart).withLastTapUp(relativeRageTapEnd).withNumOfTaps(rageTap.getNumOfTaps()).build();
    }
}

