/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.db;

import com.dynatrace.android.agent.AdkSettings;
import com.dynatrace.android.agent.Core;
import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.util.Utility;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public final class DatabaseWriteQueue
extends Thread {
    private static final int STOP_THREAD_WAIT_TIME = 1000;
    private static final String TAG = Global.LOG_PREFIX + "DatabaseWriteQueue";
    private static final long POLL_BATCH_TIME = 250L;
    private static volatile DatabaseWriteQueue theInstance;
    private static AtomicBoolean active;
    private BlockingQueue<DatabaseRecord> queue = new LinkedBlockingQueue<DatabaseRecord>();

    private DatabaseWriteQueue() {
        this.setName(TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DatabaseWriteQueue getInstance() {
        if (theInstance != null) return theInstance;
        Class<DatabaseWriteQueue> clazz = DatabaseWriteQueue.class;
        synchronized (DatabaseWriteQueue.class) {
            if (theInstance != null) return theInstance;
            theInstance = new DatabaseWriteQueue();
            // ** MonitorExit[var0] (shouldn't be in output)
            return theInstance;
        }
    }

    public void accept(DatabaseRecord record) {
        this.queue.add(record);
    }

    @Override
    public void run() {
        block4: {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "Database write queue running ...");
            }
            try {
                while (active.get()) {
                    Thread.sleep(250L);
                    this.flushQueue();
                }
            }
            catch (Exception e) {
                if (!Global.DEBUG) break block4;
                Utility.zlogE(TAG, e.toString(), e);
            }
        }
    }

    public synchronized void flushQueue() {
        LinkedList<DatabaseRecord> writeQueue = new LinkedList<DatabaseRecord>();
        DatabaseRecord nextRecord = (DatabaseRecord)this.queue.poll();
        while (nextRecord != null) {
            writeQueue.add(nextRecord);
            nextRecord = (DatabaseRecord)this.queue.poll();
        }
        if (!writeQueue.isEmpty()) {
            Core.dao.insertBatchEvents(writeQueue, AdkSettings.getInstance().getServerConfiguration());
        }
    }

    @Override
    public void start() {
        if (!active.get()) {
            active.set(true);
            super.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopThread() {
        active.set(false);
        Class<DatabaseWriteQueue> clazz = DatabaseWriteQueue.class;
        synchronized (DatabaseWriteQueue.class) {
            theInstance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.isAlive()) {
                block7: {
                    try {
                        this.join(1000L);
                    }
                    catch (InterruptedException e) {
                        if (!Global.DEBUG) break block7;
                        Utility.zlogE(TAG, e.toString());
                    }
                }
                if (this.isAlive() && Global.DEBUG) {
                    Utility.zlogD(TAG, "could not stop thread " + this.getName());
                }
            }
            return;
        }
    }

    static {
        active = new AtomicBoolean(false);
    }

    public static class DatabaseRecord {
        public String sObvc;
        public String sOa;
        public Session session;
        public int eventId;
        public long eventStart;
        public int serverId;

        public DatabaseRecord(String sObvc, String sOa, Session session, int eventId, long eventStart, int serverId) {
            this.sObvc = sObvc;
            this.sOa = sOa;
            this.session = session;
            this.eventId = eventId;
            this.eventStart = eventStart;
            this.serverId = serverId;
        }
    }
}

