/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.crash;

import com.dynatrace.android.agent.Global;
import com.dynatrace.android.agent.crash.JavaStacktraceProcessor;
import com.dynatrace.android.agent.crash.StacktraceData;
import com.dynatrace.android.agent.crash.StacktraceProcessor;
import com.dynatrace.android.agent.crash.XamarinStacktraceProcessor;
import com.dynatrace.android.agent.util.Utility;

class SafeXamarinStacktraceProcessor
implements StacktraceProcessor {
    private static final String TAG = Global.LOG_PREFIX + "SafeXamarinCrashProcessor";
    private final Throwable throwable;
    private final String exception;
    private final int maxLines;

    public SafeXamarinStacktraceProcessor(Throwable throwable, String exception, int maxLines) {
        this.throwable = throwable;
        this.exception = exception;
        this.maxLines = maxLines;
    }

    @Override
    public StacktraceData process() {
        try {
            return new XamarinStacktraceProcessor(this.exception, this.maxLines).process();
        }
        catch (Exception exception) {
            if (Global.DEBUG) {
                Utility.zlogD(TAG, "invalid Xamarin crash", exception);
            }
            return new JavaStacktraceProcessor(this.throwable, this.maxLines).process();
        }
    }
}

