/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.cookie;

import com.dynatrace.android.agent.data.Session;
import com.dynatrace.android.agent.data.VisitStoreVersion;

class CookieProducer {
    CookieProducer() {
    }

    String createAdkCookie(Session session, String encodedApplicationId) {
        String delimiter = "_";
        StringBuilder sb = new StringBuilder();
        sb.append(session.visitorId).append(delimiter);
        sb.append(session.sessionId);
        if (session.visitStoreVersion == VisitStoreVersion.V2_AGENT_SPLITTING) {
            sb.append("-").append(session.sequenceNumber);
        }
        sb.append(delimiter);
        sb.append(encodedApplicationId).append(delimiter);
        sb.append("m");
        return sb.toString();
    }

    String createAdkSettingsCookie(Session session) {
        StringBuilder adkSettings = new StringBuilder("v_4_ol_");
        if (!session.isConfigurationApplied()) {
            adkSettings.append("2");
        } else if (!session.isActive()) {
            adkSettings.append("1");
        } else {
            adkSettings.append("0_mul_");
            adkSettings.append(session.multiplicity);
        }
        adkSettings.append("_prv_");
        switch (session.getPrivacyRules().getPrivacySettings().getDataCollectionLevel()) {
            case PERFORMANCE: {
                adkSettings.append("3");
                break;
            }
            case USER_BEHAVIOR: {
                adkSettings.append("4");
                break;
            }
            default: {
                adkSettings.append("2");
            }
        }
        return adkSettings.toString();
    }

    String createDtCookie(long visitorId, long sessionId) {
        return visitorId + "_" + sessionId;
    }
}

