/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.android.agent.conf;

public final class ReplayConfiguration {
    static final ReplayConfiguration DEFAULT_REPLAY_CONFIGURATION = ReplayConfiguration.builder().build();
    private static final boolean DEFAULT_CAPTURE = false;
    private static final int DEFAULT_RETENTION_TIME = 0;
    private final boolean capture;
    private final int retentionTimeInMinutes;

    private ReplayConfiguration(Builder builder) {
        this.capture = builder.capture;
        this.retentionTimeInMinutes = builder.retentionTimeInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isCaptureOn() {
        return this.capture;
    }

    public int getRetentionTimeInMinutes() {
        return this.retentionTimeInMinutes;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplayConfiguration that = (ReplayConfiguration)o;
        if (this.capture != that.capture) {
            return false;
        }
        return this.retentionTimeInMinutes == that.retentionTimeInMinutes;
    }

    public int hashCode() {
        int result = this.capture ? 1 : 0;
        result = 31 * result + (this.retentionTimeInMinutes ^ this.retentionTimeInMinutes >>> 32);
        return result;
    }

    public String toString() {
        return "ReplayConfiguration{capture=" + this.capture + ", retentionTime=" + this.retentionTimeInMinutes + '}';
    }

    public static class Builder {
        private boolean capture;
        private int retentionTimeInMinutes;

        public Builder() {
            this.capture = false;
            this.retentionTimeInMinutes = 0;
        }

        public Builder(ReplayConfiguration oldReplayConfiguration) {
            this.capture = oldReplayConfiguration.capture;
            this.retentionTimeInMinutes = oldReplayConfiguration.retentionTimeInMinutes;
        }

        public Builder withCapture(boolean capture) {
            this.capture = capture;
            return this;
        }

        public Builder withRetentionTimeInMinutes(int retentionTimeInMinutes) {
            this.retentionTimeInMinutes = retentionTimeInMinutes;
            return this;
        }

        public ReplayConfiguration build() {
            return new ReplayConfiguration(this);
        }
    }
}

